/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pi.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.pi.model.DataPoint;
import com.amazonaws.services.pi.model.ResponseResourceMetricKey;
import com.amazonaws.services.pi.model.transform.MetricKeyDataPointsMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class MetricKeyDataPoints
implements Serializable,
Cloneable,
StructuredPojo {
    private ResponseResourceMetricKey key;
    private List<DataPoint> dataPoints;

    public void setKey(ResponseResourceMetricKey key) {
        this.key = key;
    }

    public ResponseResourceMetricKey getKey() {
        return this.key;
    }

    public MetricKeyDataPoints withKey(ResponseResourceMetricKey key) {
        this.setKey(key);
        return this;
    }

    public List<DataPoint> getDataPoints() {
        return this.dataPoints;
    }

    public void setDataPoints(Collection<DataPoint> dataPoints) {
        if (dataPoints == null) {
            this.dataPoints = null;
            return;
        }
        this.dataPoints = new ArrayList<DataPoint>(dataPoints);
    }

    public MetricKeyDataPoints withDataPoints(DataPoint ... dataPoints) {
        if (this.dataPoints == null) {
            this.setDataPoints(new ArrayList<DataPoint>(dataPoints.length));
        }
        for (DataPoint ele : dataPoints) {
            this.dataPoints.add(ele);
        }
        return this;
    }

    public MetricKeyDataPoints withDataPoints(Collection<DataPoint> dataPoints) {
        this.setDataPoints(dataPoints);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getKey() != null) {
            sb.append("Key: ").append(this.getKey()).append(",");
        }
        if (this.getDataPoints() != null) {
            sb.append("DataPoints: ").append(this.getDataPoints());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricKeyDataPoints)) {
            return false;
        }
        MetricKeyDataPoints other = (MetricKeyDataPoints)obj;
        if (other.getKey() == null ^ this.getKey() == null) {
            return false;
        }
        if (other.getKey() != null && !other.getKey().equals(this.getKey())) {
            return false;
        }
        if (other.getDataPoints() == null ^ this.getDataPoints() == null) {
            return false;
        }
        return other.getDataPoints() == null || other.getDataPoints().equals(this.getDataPoints());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getKey() == null ? 0 : this.getKey().hashCode());
        hashCode = 31 * hashCode + (this.getDataPoints() == null ? 0 : this.getDataPoints().hashCode());
        return hashCode;
    }

    public MetricKeyDataPoints clone() {
        try {
            return (MetricKeyDataPoints)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MetricKeyDataPointsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

