/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pi.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.pi.model.MetricQuery;
import com.amazonaws.services.pi.model.ServiceType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class GetResourceMetricsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String serviceType;
    private String identifier;
    private List<MetricQuery> metricQueries;
    private Date startTime;
    private Date endTime;
    private Integer periodInSeconds;
    private Integer maxResults;
    private String nextToken;

    public void setServiceType(String serviceType) {
        this.serviceType = serviceType;
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public GetResourceMetricsRequest withServiceType(String serviceType) {
        this.setServiceType(serviceType);
        return this;
    }

    public GetResourceMetricsRequest withServiceType(ServiceType serviceType) {
        this.serviceType = serviceType.toString();
        return this;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public GetResourceMetricsRequest withIdentifier(String identifier) {
        this.setIdentifier(identifier);
        return this;
    }

    public List<MetricQuery> getMetricQueries() {
        return this.metricQueries;
    }

    public void setMetricQueries(Collection<MetricQuery> metricQueries) {
        if (metricQueries == null) {
            this.metricQueries = null;
            return;
        }
        this.metricQueries = new ArrayList<MetricQuery>(metricQueries);
    }

    public GetResourceMetricsRequest withMetricQueries(MetricQuery ... metricQueries) {
        if (this.metricQueries == null) {
            this.setMetricQueries(new ArrayList<MetricQuery>(metricQueries.length));
        }
        for (MetricQuery ele : metricQueries) {
            this.metricQueries.add(ele);
        }
        return this;
    }

    public GetResourceMetricsRequest withMetricQueries(Collection<MetricQuery> metricQueries) {
        this.setMetricQueries(metricQueries);
        return this;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public GetResourceMetricsRequest withStartTime(Date startTime) {
        this.setStartTime(startTime);
        return this;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public GetResourceMetricsRequest withEndTime(Date endTime) {
        this.setEndTime(endTime);
        return this;
    }

    public void setPeriodInSeconds(Integer periodInSeconds) {
        this.periodInSeconds = periodInSeconds;
    }

    public Integer getPeriodInSeconds() {
        return this.periodInSeconds;
    }

    public GetResourceMetricsRequest withPeriodInSeconds(Integer periodInSeconds) {
        this.setPeriodInSeconds(periodInSeconds);
        return this;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public GetResourceMetricsRequest withMaxResults(Integer maxResults) {
        this.setMaxResults(maxResults);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public GetResourceMetricsRequest withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getServiceType() != null) {
            sb.append("ServiceType: ").append(this.getServiceType()).append(",");
        }
        if (this.getIdentifier() != null) {
            sb.append("Identifier: ").append(this.getIdentifier()).append(",");
        }
        if (this.getMetricQueries() != null) {
            sb.append("MetricQueries: ").append(this.getMetricQueries()).append(",");
        }
        if (this.getStartTime() != null) {
            sb.append("StartTime: ").append(this.getStartTime()).append(",");
        }
        if (this.getEndTime() != null) {
            sb.append("EndTime: ").append(this.getEndTime()).append(",");
        }
        if (this.getPeriodInSeconds() != null) {
            sb.append("PeriodInSeconds: ").append(this.getPeriodInSeconds()).append(",");
        }
        if (this.getMaxResults() != null) {
            sb.append("MaxResults: ").append(this.getMaxResults()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResourceMetricsRequest)) {
            return false;
        }
        GetResourceMetricsRequest other = (GetResourceMetricsRequest)obj;
        if (other.getServiceType() == null ^ this.getServiceType() == null) {
            return false;
        }
        if (other.getServiceType() != null && !other.getServiceType().equals(this.getServiceType())) {
            return false;
        }
        if (other.getIdentifier() == null ^ this.getIdentifier() == null) {
            return false;
        }
        if (other.getIdentifier() != null && !other.getIdentifier().equals(this.getIdentifier())) {
            return false;
        }
        if (other.getMetricQueries() == null ^ this.getMetricQueries() == null) {
            return false;
        }
        if (other.getMetricQueries() != null && !other.getMetricQueries().equals(this.getMetricQueries())) {
            return false;
        }
        if (other.getStartTime() == null ^ this.getStartTime() == null) {
            return false;
        }
        if (other.getStartTime() != null && !other.getStartTime().equals(this.getStartTime())) {
            return false;
        }
        if (other.getEndTime() == null ^ this.getEndTime() == null) {
            return false;
        }
        if (other.getEndTime() != null && !other.getEndTime().equals(this.getEndTime())) {
            return false;
        }
        if (other.getPeriodInSeconds() == null ^ this.getPeriodInSeconds() == null) {
            return false;
        }
        if (other.getPeriodInSeconds() != null && !other.getPeriodInSeconds().equals(this.getPeriodInSeconds())) {
            return false;
        }
        if (other.getMaxResults() == null ^ this.getMaxResults() == null) {
            return false;
        }
        if (other.getMaxResults() != null && !other.getMaxResults().equals(this.getMaxResults())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getServiceType() == null ? 0 : this.getServiceType().hashCode());
        hashCode = 31 * hashCode + (this.getIdentifier() == null ? 0 : this.getIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getMetricQueries() == null ? 0 : this.getMetricQueries().hashCode());
        hashCode = 31 * hashCode + (this.getStartTime() == null ? 0 : this.getStartTime().hashCode());
        hashCode = 31 * hashCode + (this.getEndTime() == null ? 0 : this.getEndTime().hashCode());
        hashCode = 31 * hashCode + (this.getPeriodInSeconds() == null ? 0 : this.getPeriodInSeconds().hashCode());
        hashCode = 31 * hashCode + (this.getMaxResults() == null ? 0 : this.getMaxResults().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    @Override
    public GetResourceMetricsRequest clone() {
        return (GetResourceMetricsRequest)super.clone();
    }
}

