/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.macie.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.macie.model.S3Resource;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DisassociateS3ResourcesRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String memberAccountId;
    private List<S3Resource> associatedS3Resources;

    public void setMemberAccountId(String memberAccountId) {
        this.memberAccountId = memberAccountId;
    }

    public String getMemberAccountId() {
        return this.memberAccountId;
    }

    public DisassociateS3ResourcesRequest withMemberAccountId(String memberAccountId) {
        this.setMemberAccountId(memberAccountId);
        return this;
    }

    public List<S3Resource> getAssociatedS3Resources() {
        return this.associatedS3Resources;
    }

    public void setAssociatedS3Resources(Collection<S3Resource> associatedS3Resources) {
        if (associatedS3Resources == null) {
            this.associatedS3Resources = null;
            return;
        }
        this.associatedS3Resources = new ArrayList<S3Resource>(associatedS3Resources);
    }

    public DisassociateS3ResourcesRequest withAssociatedS3Resources(S3Resource ... associatedS3Resources) {
        if (this.associatedS3Resources == null) {
            this.setAssociatedS3Resources(new ArrayList<S3Resource>(associatedS3Resources.length));
        }
        for (S3Resource ele : associatedS3Resources) {
            this.associatedS3Resources.add(ele);
        }
        return this;
    }

    public DisassociateS3ResourcesRequest withAssociatedS3Resources(Collection<S3Resource> associatedS3Resources) {
        this.setAssociatedS3Resources(associatedS3Resources);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMemberAccountId() != null) {
            sb.append("MemberAccountId: ").append(this.getMemberAccountId()).append(",");
        }
        if (this.getAssociatedS3Resources() != null) {
            sb.append("AssociatedS3Resources: ").append(this.getAssociatedS3Resources());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociateS3ResourcesRequest)) {
            return false;
        }
        DisassociateS3ResourcesRequest other = (DisassociateS3ResourcesRequest)obj;
        if (other.getMemberAccountId() == null ^ this.getMemberAccountId() == null) {
            return false;
        }
        if (other.getMemberAccountId() != null && !other.getMemberAccountId().equals(this.getMemberAccountId())) {
            return false;
        }
        if (other.getAssociatedS3Resources() == null ^ this.getAssociatedS3Resources() == null) {
            return false;
        }
        return other.getAssociatedS3Resources() == null || other.getAssociatedS3Resources().equals(this.getAssociatedS3Resources());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMemberAccountId() == null ? 0 : this.getMemberAccountId().hashCode());
        hashCode = 31 * hashCode + (this.getAssociatedS3Resources() == null ? 0 : this.getAssociatedS3Resources().hashCode());
        return hashCode;
    }

    @Override
    public DisassociateS3ResourcesRequest clone() {
        return (DisassociateS3ResourcesRequest)super.clone();
    }
}

