/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.macie;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.macie.AmazonMacie;
import com.amazonaws.services.macie.AmazonMacieClientBuilder;
import com.amazonaws.services.macie.model.AccessDeniedException;
import com.amazonaws.services.macie.model.AmazonMacieException;
import com.amazonaws.services.macie.model.AssociateMemberAccountRequest;
import com.amazonaws.services.macie.model.AssociateMemberAccountResult;
import com.amazonaws.services.macie.model.AssociateS3ResourcesRequest;
import com.amazonaws.services.macie.model.AssociateS3ResourcesResult;
import com.amazonaws.services.macie.model.DisassociateMemberAccountRequest;
import com.amazonaws.services.macie.model.DisassociateMemberAccountResult;
import com.amazonaws.services.macie.model.DisassociateS3ResourcesRequest;
import com.amazonaws.services.macie.model.DisassociateS3ResourcesResult;
import com.amazonaws.services.macie.model.InternalException;
import com.amazonaws.services.macie.model.InvalidInputException;
import com.amazonaws.services.macie.model.LimitExceededException;
import com.amazonaws.services.macie.model.ListMemberAccountsRequest;
import com.amazonaws.services.macie.model.ListMemberAccountsResult;
import com.amazonaws.services.macie.model.ListS3ResourcesRequest;
import com.amazonaws.services.macie.model.ListS3ResourcesResult;
import com.amazonaws.services.macie.model.UpdateS3ResourcesRequest;
import com.amazonaws.services.macie.model.UpdateS3ResourcesResult;
import com.amazonaws.services.macie.model.transform.AssociateMemberAccountRequestProtocolMarshaller;
import com.amazonaws.services.macie.model.transform.AssociateMemberAccountResultJsonUnmarshaller;
import com.amazonaws.services.macie.model.transform.AssociateS3ResourcesRequestProtocolMarshaller;
import com.amazonaws.services.macie.model.transform.AssociateS3ResourcesResultJsonUnmarshaller;
import com.amazonaws.services.macie.model.transform.DisassociateMemberAccountRequestProtocolMarshaller;
import com.amazonaws.services.macie.model.transform.DisassociateMemberAccountResultJsonUnmarshaller;
import com.amazonaws.services.macie.model.transform.DisassociateS3ResourcesRequestProtocolMarshaller;
import com.amazonaws.services.macie.model.transform.DisassociateS3ResourcesResultJsonUnmarshaller;
import com.amazonaws.services.macie.model.transform.ListMemberAccountsRequestProtocolMarshaller;
import com.amazonaws.services.macie.model.transform.ListMemberAccountsResultJsonUnmarshaller;
import com.amazonaws.services.macie.model.transform.ListS3ResourcesRequestProtocolMarshaller;
import com.amazonaws.services.macie.model.transform.ListS3ResourcesResultJsonUnmarshaller;
import com.amazonaws.services.macie.model.transform.UpdateS3ResourcesRequestProtocolMarshaller;
import com.amazonaws.services.macie.model.transform.UpdateS3ResourcesResultJsonUnmarshaller;
import com.amazonaws.thirdparty.apache.logging.Log;
import com.amazonaws.thirdparty.apache.logging.LogFactory;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;

@ThreadSafe
public class AmazonMacieClient
extends AmazonWebServiceClient
implements AmazonMacie {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonMacie.class);
    private static final String DEFAULT_SIGNING_NAME = "macie";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccessDeniedException").withModeledClass(AccessDeniedException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidInputException").withModeledClass(InvalidInputException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalException").withModeledClass(InternalException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LimitExceededException").withModeledClass(LimitExceededException.class)).withBaseServiceExceptionClass(AmazonMacieException.class));

    public static AmazonMacieClientBuilder builder() {
        return AmazonMacieClientBuilder.standard();
    }

    AmazonMacieClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AmazonMacieClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("macie.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/macie/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/macie/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public AssociateMemberAccountResult associateMemberAccount(AssociateMemberAccountRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeAssociateMemberAccount(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final AssociateMemberAccountResult executeAssociateMemberAccount(AssociateMemberAccountRequest associateMemberAccountRequest) {
        ExecutionContext executionContext = this.createExecutionContext(associateMemberAccountRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<AssociateMemberAccountRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new AssociateMemberAccountRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(associateMemberAccountRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Macie");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "AssociateMemberAccount");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new AssociateMemberAccountResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            AssociateMemberAccountResult associateMemberAccountResult = (AssociateMemberAccountResult)response.getAwsResponse();
            return associateMemberAccountResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public AssociateS3ResourcesResult associateS3Resources(AssociateS3ResourcesRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeAssociateS3Resources(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final AssociateS3ResourcesResult executeAssociateS3Resources(AssociateS3ResourcesRequest associateS3ResourcesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(associateS3ResourcesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<AssociateS3ResourcesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new AssociateS3ResourcesRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(associateS3ResourcesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Macie");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "AssociateS3Resources");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new AssociateS3ResourcesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            AssociateS3ResourcesResult associateS3ResourcesResult = (AssociateS3ResourcesResult)response.getAwsResponse();
            return associateS3ResourcesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DisassociateMemberAccountResult disassociateMemberAccount(DisassociateMemberAccountRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDisassociateMemberAccount(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DisassociateMemberAccountResult executeDisassociateMemberAccount(DisassociateMemberAccountRequest disassociateMemberAccountRequest) {
        ExecutionContext executionContext = this.createExecutionContext(disassociateMemberAccountRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DisassociateMemberAccountRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DisassociateMemberAccountRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(disassociateMemberAccountRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Macie");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DisassociateMemberAccount");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DisassociateMemberAccountResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DisassociateMemberAccountResult disassociateMemberAccountResult = (DisassociateMemberAccountResult)response.getAwsResponse();
            return disassociateMemberAccountResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DisassociateS3ResourcesResult disassociateS3Resources(DisassociateS3ResourcesRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDisassociateS3Resources(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DisassociateS3ResourcesResult executeDisassociateS3Resources(DisassociateS3ResourcesRequest disassociateS3ResourcesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(disassociateS3ResourcesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DisassociateS3ResourcesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DisassociateS3ResourcesRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(disassociateS3ResourcesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Macie");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DisassociateS3Resources");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DisassociateS3ResourcesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DisassociateS3ResourcesResult disassociateS3ResourcesResult = (DisassociateS3ResourcesResult)response.getAwsResponse();
            return disassociateS3ResourcesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListMemberAccountsResult listMemberAccounts(ListMemberAccountsRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeListMemberAccounts(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListMemberAccountsResult executeListMemberAccounts(ListMemberAccountsRequest listMemberAccountsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listMemberAccountsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListMemberAccountsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListMemberAccountsRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(listMemberAccountsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Macie");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "ListMemberAccounts");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListMemberAccountsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListMemberAccountsResult listMemberAccountsResult = (ListMemberAccountsResult)response.getAwsResponse();
            return listMemberAccountsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListS3ResourcesResult listS3Resources(ListS3ResourcesRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeListS3Resources(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListS3ResourcesResult executeListS3Resources(ListS3ResourcesRequest listS3ResourcesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listS3ResourcesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListS3ResourcesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListS3ResourcesRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(listS3ResourcesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Macie");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "ListS3Resources");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListS3ResourcesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListS3ResourcesResult listS3ResourcesResult = (ListS3ResourcesResult)response.getAwsResponse();
            return listS3ResourcesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateS3ResourcesResult updateS3Resources(UpdateS3ResourcesRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeUpdateS3Resources(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateS3ResourcesResult executeUpdateS3Resources(UpdateS3ResourcesRequest updateS3ResourcesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateS3ResourcesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateS3ResourcesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateS3ResourcesRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(updateS3ResourcesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Macie");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "UpdateS3Resources");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new UpdateS3ResourcesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateS3ResourcesResult updateS3ResourcesResult = (UpdateS3ResourcesResult)response.getAwsResponse();
            return updateS3ResourcesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider(request.getOriginalRequest(), this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }
}

