/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.macie;

import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.macie.AmazonMacieAsync;
import com.amazonaws.services.macie.AmazonMacieAsyncClientBuilder;
import com.amazonaws.services.macie.AmazonMacieClient;
import com.amazonaws.services.macie.model.AssociateMemberAccountRequest;
import com.amazonaws.services.macie.model.AssociateMemberAccountResult;
import com.amazonaws.services.macie.model.AssociateS3ResourcesRequest;
import com.amazonaws.services.macie.model.AssociateS3ResourcesResult;
import com.amazonaws.services.macie.model.DisassociateMemberAccountRequest;
import com.amazonaws.services.macie.model.DisassociateMemberAccountResult;
import com.amazonaws.services.macie.model.DisassociateS3ResourcesRequest;
import com.amazonaws.services.macie.model.DisassociateS3ResourcesResult;
import com.amazonaws.services.macie.model.ListMemberAccountsRequest;
import com.amazonaws.services.macie.model.ListMemberAccountsResult;
import com.amazonaws.services.macie.model.ListS3ResourcesRequest;
import com.amazonaws.services.macie.model.ListS3ResourcesResult;
import com.amazonaws.services.macie.model.UpdateS3ResourcesRequest;
import com.amazonaws.services.macie.model.UpdateS3ResourcesResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonMacieAsyncClient
extends AmazonMacieClient
implements AmazonMacieAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AmazonMacieAsyncClientBuilder asyncBuilder() {
        return AmazonMacieAsyncClientBuilder.standard();
    }

    AmazonMacieAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super(asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<AssociateMemberAccountResult> associateMemberAccountAsync(AssociateMemberAccountRequest request) {
        return this.associateMemberAccountAsync(request, null);
    }

    @Override
    public Future<AssociateMemberAccountResult> associateMemberAccountAsync(AssociateMemberAccountRequest request, final AsyncHandler<AssociateMemberAccountRequest, AssociateMemberAccountResult> asyncHandler) {
        final AssociateMemberAccountRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<AssociateMemberAccountResult>(){

            @Override
            public AssociateMemberAccountResult call() throws Exception {
                AssociateMemberAccountResult result = null;
                try {
                    result = AmazonMacieAsyncClient.this.executeAssociateMemberAccount(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<AssociateS3ResourcesResult> associateS3ResourcesAsync(AssociateS3ResourcesRequest request) {
        return this.associateS3ResourcesAsync(request, null);
    }

    @Override
    public Future<AssociateS3ResourcesResult> associateS3ResourcesAsync(AssociateS3ResourcesRequest request, final AsyncHandler<AssociateS3ResourcesRequest, AssociateS3ResourcesResult> asyncHandler) {
        final AssociateS3ResourcesRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<AssociateS3ResourcesResult>(){

            @Override
            public AssociateS3ResourcesResult call() throws Exception {
                AssociateS3ResourcesResult result = null;
                try {
                    result = AmazonMacieAsyncClient.this.executeAssociateS3Resources(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DisassociateMemberAccountResult> disassociateMemberAccountAsync(DisassociateMemberAccountRequest request) {
        return this.disassociateMemberAccountAsync(request, null);
    }

    @Override
    public Future<DisassociateMemberAccountResult> disassociateMemberAccountAsync(DisassociateMemberAccountRequest request, final AsyncHandler<DisassociateMemberAccountRequest, DisassociateMemberAccountResult> asyncHandler) {
        final DisassociateMemberAccountRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DisassociateMemberAccountResult>(){

            @Override
            public DisassociateMemberAccountResult call() throws Exception {
                DisassociateMemberAccountResult result = null;
                try {
                    result = AmazonMacieAsyncClient.this.executeDisassociateMemberAccount(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DisassociateS3ResourcesResult> disassociateS3ResourcesAsync(DisassociateS3ResourcesRequest request) {
        return this.disassociateS3ResourcesAsync(request, null);
    }

    @Override
    public Future<DisassociateS3ResourcesResult> disassociateS3ResourcesAsync(DisassociateS3ResourcesRequest request, final AsyncHandler<DisassociateS3ResourcesRequest, DisassociateS3ResourcesResult> asyncHandler) {
        final DisassociateS3ResourcesRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DisassociateS3ResourcesResult>(){

            @Override
            public DisassociateS3ResourcesResult call() throws Exception {
                DisassociateS3ResourcesResult result = null;
                try {
                    result = AmazonMacieAsyncClient.this.executeDisassociateS3Resources(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListMemberAccountsResult> listMemberAccountsAsync(ListMemberAccountsRequest request) {
        return this.listMemberAccountsAsync(request, null);
    }

    @Override
    public Future<ListMemberAccountsResult> listMemberAccountsAsync(ListMemberAccountsRequest request, final AsyncHandler<ListMemberAccountsRequest, ListMemberAccountsResult> asyncHandler) {
        final ListMemberAccountsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListMemberAccountsResult>(){

            @Override
            public ListMemberAccountsResult call() throws Exception {
                ListMemberAccountsResult result = null;
                try {
                    result = AmazonMacieAsyncClient.this.executeListMemberAccounts(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListS3ResourcesResult> listS3ResourcesAsync(ListS3ResourcesRequest request) {
        return this.listS3ResourcesAsync(request, null);
    }

    @Override
    public Future<ListS3ResourcesResult> listS3ResourcesAsync(ListS3ResourcesRequest request, final AsyncHandler<ListS3ResourcesRequest, ListS3ResourcesResult> asyncHandler) {
        final ListS3ResourcesRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListS3ResourcesResult>(){

            @Override
            public ListS3ResourcesResult call() throws Exception {
                ListS3ResourcesResult result = null;
                try {
                    result = AmazonMacieAsyncClient.this.executeListS3Resources(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateS3ResourcesResult> updateS3ResourcesAsync(UpdateS3ResourcesRequest request) {
        return this.updateS3ResourcesAsync(request, null);
    }

    @Override
    public Future<UpdateS3ResourcesResult> updateS3ResourcesAsync(UpdateS3ResourcesRequest request, final AsyncHandler<UpdateS3ResourcesRequest, UpdateS3ResourcesResult> asyncHandler) {
        final UpdateS3ResourcesRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateS3ResourcesResult>(){

            @Override
            public UpdateS3ResourcesResult call() throws Exception {
                UpdateS3ResourcesResult result = null;
                try {
                    result = AmazonMacieAsyncClient.this.executeUpdateS3Resources(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

