/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisanalyticsv2.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.kinesisanalyticsv2.model.S3ContentLocation;

@SdkInternalApi
public class S3ContentLocationMarshaller {
    private static final MarshallingInfo<String> BUCKETARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BucketARN").build();
    private static final MarshallingInfo<String> FILEKEY_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FileKey").build();
    private static final MarshallingInfo<String> OBJECTVERSION_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ObjectVersion").build();
    private static final S3ContentLocationMarshaller instance = new S3ContentLocationMarshaller();

    public static S3ContentLocationMarshaller getInstance() {
        return instance;
    }

    public void marshall(S3ContentLocation s3ContentLocation, ProtocolMarshaller protocolMarshaller) {
        if (s3ContentLocation == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(s3ContentLocation.getBucketARN(), BUCKETARN_BINDING);
            protocolMarshaller.marshall(s3ContentLocation.getFileKey(), FILEKEY_BINDING);
            protocolMarshaller.marshall(s3ContentLocation.getObjectVersion(), OBJECTVERSION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

