/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisanalyticsv2.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.kinesisanalyticsv2.model.RunConfiguration;
import java.util.List;

@SdkInternalApi
public class RunConfigurationMarshaller {
    private static final MarshallingInfo<List> SQLRUNCONFIGURATIONS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SqlRunConfigurations").build();
    private static final MarshallingInfo<StructuredPojo> APPLICATIONRESTORECONFIGURATION_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ApplicationRestoreConfiguration").build();
    private static final RunConfigurationMarshaller instance = new RunConfigurationMarshaller();

    public static RunConfigurationMarshaller getInstance() {
        return instance;
    }

    public void marshall(RunConfiguration runConfiguration, ProtocolMarshaller protocolMarshaller) {
        if (runConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(runConfiguration.getSqlRunConfigurations(), SQLRUNCONFIGURATIONS_BINDING);
            protocolMarshaller.marshall(runConfiguration.getApplicationRestoreConfiguration(), APPLICATIONRESTORECONFIGURATION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

