/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisanalyticsv2.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.kinesisanalyticsv2.model.OutputUpdate;

@SdkInternalApi
public class OutputUpdateMarshaller {
    private static final MarshallingInfo<String> OUTPUTID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OutputId").build();
    private static final MarshallingInfo<String> NAMEUPDATE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NameUpdate").build();
    private static final MarshallingInfo<StructuredPojo> KINESISSTREAMSOUTPUTUPDATE_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KinesisStreamsOutputUpdate").build();
    private static final MarshallingInfo<StructuredPojo> KINESISFIREHOSEOUTPUTUPDATE_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KinesisFirehoseOutputUpdate").build();
    private static final MarshallingInfo<StructuredPojo> LAMBDAOUTPUTUPDATE_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LambdaOutputUpdate").build();
    private static final MarshallingInfo<StructuredPojo> DESTINATIONSCHEMAUPDATE_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DestinationSchemaUpdate").build();
    private static final OutputUpdateMarshaller instance = new OutputUpdateMarshaller();

    public static OutputUpdateMarshaller getInstance() {
        return instance;
    }

    public void marshall(OutputUpdate outputUpdate, ProtocolMarshaller protocolMarshaller) {
        if (outputUpdate == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(outputUpdate.getOutputId(), OUTPUTID_BINDING);
            protocolMarshaller.marshall(outputUpdate.getNameUpdate(), NAMEUPDATE_BINDING);
            protocolMarshaller.marshall(outputUpdate.getKinesisStreamsOutputUpdate(), KINESISSTREAMSOUTPUTUPDATE_BINDING);
            protocolMarshaller.marshall(outputUpdate.getKinesisFirehoseOutputUpdate(), KINESISFIREHOSEOUTPUTUPDATE_BINDING);
            protocolMarshaller.marshall(outputUpdate.getLambdaOutputUpdate(), LAMBDAOUTPUTUPDATE_BINDING);
            protocolMarshaller.marshall(outputUpdate.getDestinationSchemaUpdate(), DESTINATIONSCHEMAUPDATE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

