/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisanalyticsv2.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.kinesisanalyticsv2.model.OutputDescription;

@SdkInternalApi
public class OutputDescriptionMarshaller {
    private static final MarshallingInfo<String> OUTPUTID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OutputId").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<StructuredPojo> KINESISSTREAMSOUTPUTDESCRIPTION_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KinesisStreamsOutputDescription").build();
    private static final MarshallingInfo<StructuredPojo> KINESISFIREHOSEOUTPUTDESCRIPTION_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KinesisFirehoseOutputDescription").build();
    private static final MarshallingInfo<StructuredPojo> LAMBDAOUTPUTDESCRIPTION_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LambdaOutputDescription").build();
    private static final MarshallingInfo<StructuredPojo> DESTINATIONSCHEMA_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DestinationSchema").build();
    private static final OutputDescriptionMarshaller instance = new OutputDescriptionMarshaller();

    public static OutputDescriptionMarshaller getInstance() {
        return instance;
    }

    public void marshall(OutputDescription outputDescription, ProtocolMarshaller protocolMarshaller) {
        if (outputDescription == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(outputDescription.getOutputId(), OUTPUTID_BINDING);
            protocolMarshaller.marshall(outputDescription.getName(), NAME_BINDING);
            protocolMarshaller.marshall(outputDescription.getKinesisStreamsOutputDescription(), KINESISSTREAMSOUTPUTDESCRIPTION_BINDING);
            protocolMarshaller.marshall(outputDescription.getKinesisFirehoseOutputDescription(), KINESISFIREHOSEOUTPUTDESCRIPTION_BINDING);
            protocolMarshaller.marshall(outputDescription.getLambdaOutputDescription(), LAMBDAOUTPUTDESCRIPTION_BINDING);
            protocolMarshaller.marshall(outputDescription.getDestinationSchema(), DESTINATIONSCHEMA_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

