/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisanalyticsv2.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.kinesisanalyticsv2.model.InputUpdate;
import com.amazonaws.services.kinesisanalyticsv2.model.OutputUpdate;
import com.amazonaws.services.kinesisanalyticsv2.model.ReferenceDataSourceUpdate;
import com.amazonaws.services.kinesisanalyticsv2.model.transform.SqlApplicationConfigurationUpdateMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SqlApplicationConfigurationUpdate
implements Serializable,
Cloneable,
StructuredPojo {
    private List<InputUpdate> inputUpdates;
    private List<OutputUpdate> outputUpdates;
    private List<ReferenceDataSourceUpdate> referenceDataSourceUpdates;

    public List<InputUpdate> getInputUpdates() {
        return this.inputUpdates;
    }

    public void setInputUpdates(Collection<InputUpdate> inputUpdates) {
        if (inputUpdates == null) {
            this.inputUpdates = null;
            return;
        }
        this.inputUpdates = new ArrayList<InputUpdate>(inputUpdates);
    }

    public SqlApplicationConfigurationUpdate withInputUpdates(InputUpdate ... inputUpdates) {
        if (this.inputUpdates == null) {
            this.setInputUpdates(new ArrayList<InputUpdate>(inputUpdates.length));
        }
        for (InputUpdate ele : inputUpdates) {
            this.inputUpdates.add(ele);
        }
        return this;
    }

    public SqlApplicationConfigurationUpdate withInputUpdates(Collection<InputUpdate> inputUpdates) {
        this.setInputUpdates(inputUpdates);
        return this;
    }

    public List<OutputUpdate> getOutputUpdates() {
        return this.outputUpdates;
    }

    public void setOutputUpdates(Collection<OutputUpdate> outputUpdates) {
        if (outputUpdates == null) {
            this.outputUpdates = null;
            return;
        }
        this.outputUpdates = new ArrayList<OutputUpdate>(outputUpdates);
    }

    public SqlApplicationConfigurationUpdate withOutputUpdates(OutputUpdate ... outputUpdates) {
        if (this.outputUpdates == null) {
            this.setOutputUpdates(new ArrayList<OutputUpdate>(outputUpdates.length));
        }
        for (OutputUpdate ele : outputUpdates) {
            this.outputUpdates.add(ele);
        }
        return this;
    }

    public SqlApplicationConfigurationUpdate withOutputUpdates(Collection<OutputUpdate> outputUpdates) {
        this.setOutputUpdates(outputUpdates);
        return this;
    }

    public List<ReferenceDataSourceUpdate> getReferenceDataSourceUpdates() {
        return this.referenceDataSourceUpdates;
    }

    public void setReferenceDataSourceUpdates(Collection<ReferenceDataSourceUpdate> referenceDataSourceUpdates) {
        if (referenceDataSourceUpdates == null) {
            this.referenceDataSourceUpdates = null;
            return;
        }
        this.referenceDataSourceUpdates = new ArrayList<ReferenceDataSourceUpdate>(referenceDataSourceUpdates);
    }

    public SqlApplicationConfigurationUpdate withReferenceDataSourceUpdates(ReferenceDataSourceUpdate ... referenceDataSourceUpdates) {
        if (this.referenceDataSourceUpdates == null) {
            this.setReferenceDataSourceUpdates(new ArrayList<ReferenceDataSourceUpdate>(referenceDataSourceUpdates.length));
        }
        for (ReferenceDataSourceUpdate ele : referenceDataSourceUpdates) {
            this.referenceDataSourceUpdates.add(ele);
        }
        return this;
    }

    public SqlApplicationConfigurationUpdate withReferenceDataSourceUpdates(Collection<ReferenceDataSourceUpdate> referenceDataSourceUpdates) {
        this.setReferenceDataSourceUpdates(referenceDataSourceUpdates);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getInputUpdates() != null) {
            sb.append("InputUpdates: ").append(this.getInputUpdates()).append(",");
        }
        if (this.getOutputUpdates() != null) {
            sb.append("OutputUpdates: ").append(this.getOutputUpdates()).append(",");
        }
        if (this.getReferenceDataSourceUpdates() != null) {
            sb.append("ReferenceDataSourceUpdates: ").append(this.getReferenceDataSourceUpdates());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SqlApplicationConfigurationUpdate)) {
            return false;
        }
        SqlApplicationConfigurationUpdate other = (SqlApplicationConfigurationUpdate)obj;
        if (other.getInputUpdates() == null ^ this.getInputUpdates() == null) {
            return false;
        }
        if (other.getInputUpdates() != null && !other.getInputUpdates().equals(this.getInputUpdates())) {
            return false;
        }
        if (other.getOutputUpdates() == null ^ this.getOutputUpdates() == null) {
            return false;
        }
        if (other.getOutputUpdates() != null && !other.getOutputUpdates().equals(this.getOutputUpdates())) {
            return false;
        }
        if (other.getReferenceDataSourceUpdates() == null ^ this.getReferenceDataSourceUpdates() == null) {
            return false;
        }
        return other.getReferenceDataSourceUpdates() == null || other.getReferenceDataSourceUpdates().equals(this.getReferenceDataSourceUpdates());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getInputUpdates() == null ? 0 : this.getInputUpdates().hashCode());
        hashCode = 31 * hashCode + (this.getOutputUpdates() == null ? 0 : this.getOutputUpdates().hashCode());
        hashCode = 31 * hashCode + (this.getReferenceDataSourceUpdates() == null ? 0 : this.getReferenceDataSourceUpdates().hashCode());
        return hashCode;
    }

    public SqlApplicationConfigurationUpdate clone() {
        try {
            return (SqlApplicationConfigurationUpdate)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SqlApplicationConfigurationUpdateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

