/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisanalyticsv2.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.kinesisanalyticsv2.model.transform.S3ContentLocationMarshaller;
import java.io.Serializable;

public class S3ContentLocation
implements Serializable,
Cloneable,
StructuredPojo {
    private String bucketARN;
    private String fileKey;
    private String objectVersion;

    public void setBucketARN(String bucketARN) {
        this.bucketARN = bucketARN;
    }

    public String getBucketARN() {
        return this.bucketARN;
    }

    public S3ContentLocation withBucketARN(String bucketARN) {
        this.setBucketARN(bucketARN);
        return this;
    }

    public void setFileKey(String fileKey) {
        this.fileKey = fileKey;
    }

    public String getFileKey() {
        return this.fileKey;
    }

    public S3ContentLocation withFileKey(String fileKey) {
        this.setFileKey(fileKey);
        return this;
    }

    public void setObjectVersion(String objectVersion) {
        this.objectVersion = objectVersion;
    }

    public String getObjectVersion() {
        return this.objectVersion;
    }

    public S3ContentLocation withObjectVersion(String objectVersion) {
        this.setObjectVersion(objectVersion);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBucketARN() != null) {
            sb.append("BucketARN: ").append(this.getBucketARN()).append(",");
        }
        if (this.getFileKey() != null) {
            sb.append("FileKey: ").append(this.getFileKey()).append(",");
        }
        if (this.getObjectVersion() != null) {
            sb.append("ObjectVersion: ").append(this.getObjectVersion());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3ContentLocation)) {
            return false;
        }
        S3ContentLocation other = (S3ContentLocation)obj;
        if (other.getBucketARN() == null ^ this.getBucketARN() == null) {
            return false;
        }
        if (other.getBucketARN() != null && !other.getBucketARN().equals(this.getBucketARN())) {
            return false;
        }
        if (other.getFileKey() == null ^ this.getFileKey() == null) {
            return false;
        }
        if (other.getFileKey() != null && !other.getFileKey().equals(this.getFileKey())) {
            return false;
        }
        if (other.getObjectVersion() == null ^ this.getObjectVersion() == null) {
            return false;
        }
        return other.getObjectVersion() == null || other.getObjectVersion().equals(this.getObjectVersion());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBucketARN() == null ? 0 : this.getBucketARN().hashCode());
        hashCode = 31 * hashCode + (this.getFileKey() == null ? 0 : this.getFileKey().hashCode());
        hashCode = 31 * hashCode + (this.getObjectVersion() == null ? 0 : this.getObjectVersion().hashCode());
        return hashCode;
    }

    public S3ContentLocation clone() {
        try {
            return (S3ContentLocation)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        S3ContentLocationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

