/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotthingsgraph.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.iotthingsgraph.model.Thing;

@SdkInternalApi
public class ThingMarshaller {
    private static final MarshallingInfo<String> THINGARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("thingArn").build();
    private static final MarshallingInfo<String> THINGNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("thingName").build();
    private static final ThingMarshaller instance = new ThingMarshaller();

    public static ThingMarshaller getInstance() {
        return instance;
    }

    public void marshall(Thing thing, ProtocolMarshaller protocolMarshaller) {
        if (thing == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(thing.getThingArn(), THINGARN_BINDING);
            protocolMarshaller.marshall(thing.getThingName(), THINGNAME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

