/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotthingsgraph.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.iotthingsgraph.model.SystemInstanceDescription;
import java.util.List;

@SdkInternalApi
public class SystemInstanceDescriptionMarshaller {
    private static final MarshallingInfo<StructuredPojo> SUMMARY_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("summary").build();
    private static final MarshallingInfo<StructuredPojo> DEFINITION_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("definition").build();
    private static final MarshallingInfo<String> S3BUCKETNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("s3BucketName").build();
    private static final MarshallingInfo<StructuredPojo> METRICSCONFIGURATION_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("metricsConfiguration").build();
    private static final MarshallingInfo<Long> VALIDATEDNAMESPACEVERSION_BINDING = MarshallingInfo.builder(MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("validatedNamespaceVersion").build();
    private static final MarshallingInfo<List> VALIDATEDDEPENDENCYREVISIONS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("validatedDependencyRevisions").build();
    private static final MarshallingInfo<String> FLOWACTIONSROLEARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("flowActionsRoleArn").build();
    private static final SystemInstanceDescriptionMarshaller instance = new SystemInstanceDescriptionMarshaller();

    public static SystemInstanceDescriptionMarshaller getInstance() {
        return instance;
    }

    public void marshall(SystemInstanceDescription systemInstanceDescription, ProtocolMarshaller protocolMarshaller) {
        if (systemInstanceDescription == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(systemInstanceDescription.getSummary(), SUMMARY_BINDING);
            protocolMarshaller.marshall(systemInstanceDescription.getDefinition(), DEFINITION_BINDING);
            protocolMarshaller.marshall(systemInstanceDescription.getS3BucketName(), S3BUCKETNAME_BINDING);
            protocolMarshaller.marshall(systemInstanceDescription.getMetricsConfiguration(), METRICSCONFIGURATION_BINDING);
            protocolMarshaller.marshall(systemInstanceDescription.getValidatedNamespaceVersion(), VALIDATEDNAMESPACEVERSION_BINDING);
            protocolMarshaller.marshall(systemInstanceDescription.getValidatedDependencyRevisions(), VALIDATEDDEPENDENCYREVISIONS_BINDING);
            protocolMarshaller.marshall(systemInstanceDescription.getFlowActionsRoleArn(), FLOWACTIONSROLEARN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

