/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotthingsgraph.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.iotthingsgraph.model.EntityFilter;
import com.amazonaws.services.iotthingsgraph.model.EntityType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SearchEntitiesRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private List<String> entityTypes;
    private List<EntityFilter> filters;
    private String nextToken;
    private Integer maxResults;
    private Long namespaceVersion;

    public List<String> getEntityTypes() {
        return this.entityTypes;
    }

    public void setEntityTypes(Collection<String> entityTypes) {
        if (entityTypes == null) {
            this.entityTypes = null;
            return;
        }
        this.entityTypes = new ArrayList<String>(entityTypes);
    }

    public SearchEntitiesRequest withEntityTypes(String ... entityTypes) {
        if (this.entityTypes == null) {
            this.setEntityTypes(new ArrayList<String>(entityTypes.length));
        }
        for (String ele : entityTypes) {
            this.entityTypes.add(ele);
        }
        return this;
    }

    public SearchEntitiesRequest withEntityTypes(Collection<String> entityTypes) {
        this.setEntityTypes(entityTypes);
        return this;
    }

    public SearchEntitiesRequest withEntityTypes(EntityType ... entityTypes) {
        ArrayList<String> entityTypesCopy = new ArrayList<String>(entityTypes.length);
        for (EntityType value : entityTypes) {
            entityTypesCopy.add(value.toString());
        }
        if (this.getEntityTypes() == null) {
            this.setEntityTypes(entityTypesCopy);
        } else {
            this.getEntityTypes().addAll(entityTypesCopy);
        }
        return this;
    }

    public List<EntityFilter> getFilters() {
        return this.filters;
    }

    public void setFilters(Collection<EntityFilter> filters) {
        if (filters == null) {
            this.filters = null;
            return;
        }
        this.filters = new ArrayList<EntityFilter>(filters);
    }

    public SearchEntitiesRequest withFilters(EntityFilter ... filters) {
        if (this.filters == null) {
            this.setFilters(new ArrayList<EntityFilter>(filters.length));
        }
        for (EntityFilter ele : filters) {
            this.filters.add(ele);
        }
        return this;
    }

    public SearchEntitiesRequest withFilters(Collection<EntityFilter> filters) {
        this.setFilters(filters);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public SearchEntitiesRequest withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public SearchEntitiesRequest withMaxResults(Integer maxResults) {
        this.setMaxResults(maxResults);
        return this;
    }

    public void setNamespaceVersion(Long namespaceVersion) {
        this.namespaceVersion = namespaceVersion;
    }

    public Long getNamespaceVersion() {
        return this.namespaceVersion;
    }

    public SearchEntitiesRequest withNamespaceVersion(Long namespaceVersion) {
        this.setNamespaceVersion(namespaceVersion);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEntityTypes() != null) {
            sb.append("EntityTypes: ").append(this.getEntityTypes()).append(",");
        }
        if (this.getFilters() != null) {
            sb.append("Filters: ").append(this.getFilters()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getMaxResults() != null) {
            sb.append("MaxResults: ").append(this.getMaxResults()).append(",");
        }
        if (this.getNamespaceVersion() != null) {
            sb.append("NamespaceVersion: ").append(this.getNamespaceVersion());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchEntitiesRequest)) {
            return false;
        }
        SearchEntitiesRequest other = (SearchEntitiesRequest)obj;
        if (other.getEntityTypes() == null ^ this.getEntityTypes() == null) {
            return false;
        }
        if (other.getEntityTypes() != null && !other.getEntityTypes().equals(this.getEntityTypes())) {
            return false;
        }
        if (other.getFilters() == null ^ this.getFilters() == null) {
            return false;
        }
        if (other.getFilters() != null && !other.getFilters().equals(this.getFilters())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getMaxResults() == null ^ this.getMaxResults() == null) {
            return false;
        }
        if (other.getMaxResults() != null && !other.getMaxResults().equals(this.getMaxResults())) {
            return false;
        }
        if (other.getNamespaceVersion() == null ^ this.getNamespaceVersion() == null) {
            return false;
        }
        return other.getNamespaceVersion() == null || other.getNamespaceVersion().equals(this.getNamespaceVersion());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEntityTypes() == null ? 0 : this.getEntityTypes().hashCode());
        hashCode = 31 * hashCode + (this.getFilters() == null ? 0 : this.getFilters().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getMaxResults() == null ? 0 : this.getMaxResults().hashCode());
        hashCode = 31 * hashCode + (this.getNamespaceVersion() == null ? 0 : this.getNamespaceVersion().hashCode());
        return hashCode;
    }

    @Override
    public SearchEntitiesRequest clone() {
        return (SearchEntitiesRequest)super.clone();
    }
}

