/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ioteventsdata.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.ioteventsdata.model.Timer;
import com.amazonaws.services.ioteventsdata.model.Variable;
import com.amazonaws.services.ioteventsdata.model.transform.DetectorStateMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DetectorState
implements Serializable,
Cloneable,
StructuredPojo {
    private String stateName;
    private List<Variable> variables;
    private List<Timer> timers;

    public void setStateName(String stateName) {
        this.stateName = stateName;
    }

    public String getStateName() {
        return this.stateName;
    }

    public DetectorState withStateName(String stateName) {
        this.setStateName(stateName);
        return this;
    }

    public List<Variable> getVariables() {
        return this.variables;
    }

    public void setVariables(Collection<Variable> variables) {
        if (variables == null) {
            this.variables = null;
            return;
        }
        this.variables = new ArrayList<Variable>(variables);
    }

    public DetectorState withVariables(Variable ... variables) {
        if (this.variables == null) {
            this.setVariables(new ArrayList<Variable>(variables.length));
        }
        for (Variable ele : variables) {
            this.variables.add(ele);
        }
        return this;
    }

    public DetectorState withVariables(Collection<Variable> variables) {
        this.setVariables(variables);
        return this;
    }

    public List<Timer> getTimers() {
        return this.timers;
    }

    public void setTimers(Collection<Timer> timers) {
        if (timers == null) {
            this.timers = null;
            return;
        }
        this.timers = new ArrayList<Timer>(timers);
    }

    public DetectorState withTimers(Timer ... timers) {
        if (this.timers == null) {
            this.setTimers(new ArrayList<Timer>(timers.length));
        }
        for (Timer ele : timers) {
            this.timers.add(ele);
        }
        return this;
    }

    public DetectorState withTimers(Collection<Timer> timers) {
        this.setTimers(timers);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getStateName() != null) {
            sb.append("StateName: ").append(this.getStateName()).append(",");
        }
        if (this.getVariables() != null) {
            sb.append("Variables: ").append(this.getVariables()).append(",");
        }
        if (this.getTimers() != null) {
            sb.append("Timers: ").append(this.getTimers());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectorState)) {
            return false;
        }
        DetectorState other = (DetectorState)obj;
        if (other.getStateName() == null ^ this.getStateName() == null) {
            return false;
        }
        if (other.getStateName() != null && !other.getStateName().equals(this.getStateName())) {
            return false;
        }
        if (other.getVariables() == null ^ this.getVariables() == null) {
            return false;
        }
        if (other.getVariables() != null && !other.getVariables().equals(this.getVariables())) {
            return false;
        }
        if (other.getTimers() == null ^ this.getTimers() == null) {
            return false;
        }
        return other.getTimers() == null || other.getTimers().equals(this.getTimers());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getStateName() == null ? 0 : this.getStateName().hashCode());
        hashCode = 31 * hashCode + (this.getVariables() == null ? 0 : this.getVariables().hashCode());
        hashCode = 31 * hashCode + (this.getTimers() == null ? 0 : this.getTimers().hashCode());
        return hashCode;
    }

    public DetectorState clone() {
        try {
            return (DetectorState)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DetectorStateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

