/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ioteventsdata.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.ioteventsdata.model.Message;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BatchPutMessageRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private List<Message> messages;

    public List<Message> getMessages() {
        return this.messages;
    }

    public void setMessages(Collection<Message> messages) {
        if (messages == null) {
            this.messages = null;
            return;
        }
        this.messages = new ArrayList<Message>(messages);
    }

    public BatchPutMessageRequest withMessages(Message ... messages) {
        if (this.messages == null) {
            this.setMessages(new ArrayList<Message>(messages.length));
        }
        for (Message ele : messages) {
            this.messages.add(ele);
        }
        return this;
    }

    public BatchPutMessageRequest withMessages(Collection<Message> messages) {
        this.setMessages(messages);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMessages() != null) {
            sb.append("Messages: ").append(this.getMessages());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchPutMessageRequest)) {
            return false;
        }
        BatchPutMessageRequest other = (BatchPutMessageRequest)obj;
        if (other.getMessages() == null ^ this.getMessages() == null) {
            return false;
        }
        return other.getMessages() == null || other.getMessages().equals(this.getMessages());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMessages() == null ? 0 : this.getMessages().hashCode());
        return hashCode;
    }

    @Override
    public BatchPutMessageRequest clone() {
        return (BatchPutMessageRequest)super.clone();
    }
}

