/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotevents.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.iotevents.model.InputDefinition;
import com.amazonaws.services.iotevents.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateInputRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String inputName;
    private String inputDescription;
    private InputDefinition inputDefinition;
    private List<Tag> tags;

    public void setInputName(String inputName) {
        this.inputName = inputName;
    }

    public String getInputName() {
        return this.inputName;
    }

    public CreateInputRequest withInputName(String inputName) {
        this.setInputName(inputName);
        return this;
    }

    public void setInputDescription(String inputDescription) {
        this.inputDescription = inputDescription;
    }

    public String getInputDescription() {
        return this.inputDescription;
    }

    public CreateInputRequest withInputDescription(String inputDescription) {
        this.setInputDescription(inputDescription);
        return this;
    }

    public void setInputDefinition(InputDefinition inputDefinition) {
        this.inputDefinition = inputDefinition;
    }

    public InputDefinition getInputDefinition() {
        return this.inputDefinition;
    }

    public CreateInputRequest withInputDefinition(InputDefinition inputDefinition) {
        this.setInputDefinition(inputDefinition);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreateInputRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateInputRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getInputName() != null) {
            sb.append("InputName: ").append(this.getInputName()).append(",");
        }
        if (this.getInputDescription() != null) {
            sb.append("InputDescription: ").append(this.getInputDescription()).append(",");
        }
        if (this.getInputDefinition() != null) {
            sb.append("InputDefinition: ").append(this.getInputDefinition()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateInputRequest)) {
            return false;
        }
        CreateInputRequest other = (CreateInputRequest)obj;
        if (other.getInputName() == null ^ this.getInputName() == null) {
            return false;
        }
        if (other.getInputName() != null && !other.getInputName().equals(this.getInputName())) {
            return false;
        }
        if (other.getInputDescription() == null ^ this.getInputDescription() == null) {
            return false;
        }
        if (other.getInputDescription() != null && !other.getInputDescription().equals(this.getInputDescription())) {
            return false;
        }
        if (other.getInputDefinition() == null ^ this.getInputDefinition() == null) {
            return false;
        }
        if (other.getInputDefinition() != null && !other.getInputDefinition().equals(this.getInputDefinition())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getInputName() == null ? 0 : this.getInputName().hashCode());
        hashCode = 31 * hashCode + (this.getInputDescription() == null ? 0 : this.getInputDescription().hashCode());
        hashCode = 31 * hashCode + (this.getInputDefinition() == null ? 0 : this.getInputDefinition().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    @Override
    public CreateInputRequest clone() {
        return (CreateInputRequest)super.clone();
    }
}

