/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotanalytics.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.iotanalytics.model.Pipeline;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class PipelineMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").build();
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("arn").build();
    private static final MarshallingInfo<List> ACTIVITIES_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("activities").build();
    private static final MarshallingInfo<List> REPROCESSINGSUMMARIES_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("reprocessingSummaries").build();
    private static final MarshallingInfo<Date> CREATIONTIME_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("creationTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> LASTUPDATETIME_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastUpdateTime").timestampFormat("unixTimestamp").build();
    private static final PipelineMarshaller instance = new PipelineMarshaller();

    public static PipelineMarshaller getInstance() {
        return instance;
    }

    public void marshall(Pipeline pipeline, ProtocolMarshaller protocolMarshaller) {
        if (pipeline == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(pipeline.getName(), NAME_BINDING);
            protocolMarshaller.marshall(pipeline.getArn(), ARN_BINDING);
            protocolMarshaller.marshall(pipeline.getActivities(), ACTIVITIES_BINDING);
            protocolMarshaller.marshall(pipeline.getReprocessingSummaries(), REPROCESSINGSUMMARIES_BINDING);
            protocolMarshaller.marshall(pipeline.getCreationTime(), CREATIONTIME_BINDING);
            protocolMarshaller.marshall(pipeline.getLastUpdateTime(), LASTUPDATETIME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

