/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotanalytics.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.iotanalytics.model.PipelineActivity;
import com.amazonaws.services.iotanalytics.model.ReprocessingSummary;
import com.amazonaws.services.iotanalytics.model.transform.PipelineMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class Pipeline
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private String arn;
    private List<PipelineActivity> activities;
    private List<ReprocessingSummary> reprocessingSummaries;
    private Date creationTime;
    private Date lastUpdateTime;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Pipeline withName(String name) {
        this.setName(name);
        return this;
    }

    public void setArn(String arn) {
        this.arn = arn;
    }

    public String getArn() {
        return this.arn;
    }

    public Pipeline withArn(String arn) {
        this.setArn(arn);
        return this;
    }

    public List<PipelineActivity> getActivities() {
        return this.activities;
    }

    public void setActivities(Collection<PipelineActivity> activities) {
        if (activities == null) {
            this.activities = null;
            return;
        }
        this.activities = new ArrayList<PipelineActivity>(activities);
    }

    public Pipeline withActivities(PipelineActivity ... activities) {
        if (this.activities == null) {
            this.setActivities(new ArrayList<PipelineActivity>(activities.length));
        }
        for (PipelineActivity ele : activities) {
            this.activities.add(ele);
        }
        return this;
    }

    public Pipeline withActivities(Collection<PipelineActivity> activities) {
        this.setActivities(activities);
        return this;
    }

    public List<ReprocessingSummary> getReprocessingSummaries() {
        return this.reprocessingSummaries;
    }

    public void setReprocessingSummaries(Collection<ReprocessingSummary> reprocessingSummaries) {
        if (reprocessingSummaries == null) {
            this.reprocessingSummaries = null;
            return;
        }
        this.reprocessingSummaries = new ArrayList<ReprocessingSummary>(reprocessingSummaries);
    }

    public Pipeline withReprocessingSummaries(ReprocessingSummary ... reprocessingSummaries) {
        if (this.reprocessingSummaries == null) {
            this.setReprocessingSummaries(new ArrayList<ReprocessingSummary>(reprocessingSummaries.length));
        }
        for (ReprocessingSummary ele : reprocessingSummaries) {
            this.reprocessingSummaries.add(ele);
        }
        return this;
    }

    public Pipeline withReprocessingSummaries(Collection<ReprocessingSummary> reprocessingSummaries) {
        this.setReprocessingSummaries(reprocessingSummaries);
        return this;
    }

    public void setCreationTime(Date creationTime) {
        this.creationTime = creationTime;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public Pipeline withCreationTime(Date creationTime) {
        this.setCreationTime(creationTime);
        return this;
    }

    public void setLastUpdateTime(Date lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    public Date getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public Pipeline withLastUpdateTime(Date lastUpdateTime) {
        this.setLastUpdateTime(lastUpdateTime);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getArn() != null) {
            sb.append("Arn: ").append(this.getArn()).append(",");
        }
        if (this.getActivities() != null) {
            sb.append("Activities: ").append(this.getActivities()).append(",");
        }
        if (this.getReprocessingSummaries() != null) {
            sb.append("ReprocessingSummaries: ").append(this.getReprocessingSummaries()).append(",");
        }
        if (this.getCreationTime() != null) {
            sb.append("CreationTime: ").append(this.getCreationTime()).append(",");
        }
        if (this.getLastUpdateTime() != null) {
            sb.append("LastUpdateTime: ").append(this.getLastUpdateTime());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Pipeline)) {
            return false;
        }
        Pipeline other = (Pipeline)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getArn() == null ^ this.getArn() == null) {
            return false;
        }
        if (other.getArn() != null && !other.getArn().equals(this.getArn())) {
            return false;
        }
        if (other.getActivities() == null ^ this.getActivities() == null) {
            return false;
        }
        if (other.getActivities() != null && !other.getActivities().equals(this.getActivities())) {
            return false;
        }
        if (other.getReprocessingSummaries() == null ^ this.getReprocessingSummaries() == null) {
            return false;
        }
        if (other.getReprocessingSummaries() != null && !other.getReprocessingSummaries().equals(this.getReprocessingSummaries())) {
            return false;
        }
        if (other.getCreationTime() == null ^ this.getCreationTime() == null) {
            return false;
        }
        if (other.getCreationTime() != null && !other.getCreationTime().equals(this.getCreationTime())) {
            return false;
        }
        if (other.getLastUpdateTime() == null ^ this.getLastUpdateTime() == null) {
            return false;
        }
        return other.getLastUpdateTime() == null || other.getLastUpdateTime().equals(this.getLastUpdateTime());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getArn() == null ? 0 : this.getArn().hashCode());
        hashCode = 31 * hashCode + (this.getActivities() == null ? 0 : this.getActivities().hashCode());
        hashCode = 31 * hashCode + (this.getReprocessingSummaries() == null ? 0 : this.getReprocessingSummaries().hashCode());
        hashCode = 31 * hashCode + (this.getCreationTime() == null ? 0 : this.getCreationTime().hashCode());
        hashCode = 31 * hashCode + (this.getLastUpdateTime() == null ? 0 : this.getLastUpdateTime().hashCode());
        return hashCode;
    }

    public Pipeline clone() {
        try {
            return (Pipeline)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PipelineMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

