/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot1clickprojects.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.iot1clickprojects.model.transform.DeviceTemplateMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class DeviceTemplate
implements Serializable,
Cloneable,
StructuredPojo {
    private String deviceType;
    private Map<String, String> callbackOverrides;

    public void setDeviceType(String deviceType) {
        this.deviceType = deviceType;
    }

    public String getDeviceType() {
        return this.deviceType;
    }

    public DeviceTemplate withDeviceType(String deviceType) {
        this.setDeviceType(deviceType);
        return this;
    }

    public Map<String, String> getCallbackOverrides() {
        return this.callbackOverrides;
    }

    public void setCallbackOverrides(Map<String, String> callbackOverrides) {
        this.callbackOverrides = callbackOverrides;
    }

    public DeviceTemplate withCallbackOverrides(Map<String, String> callbackOverrides) {
        this.setCallbackOverrides(callbackOverrides);
        return this;
    }

    public DeviceTemplate addCallbackOverridesEntry(String key, String value) {
        if (null == this.callbackOverrides) {
            this.callbackOverrides = new HashMap<String, String>();
        }
        if (this.callbackOverrides.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.callbackOverrides.put(key, value);
        return this;
    }

    public DeviceTemplate clearCallbackOverridesEntries() {
        this.callbackOverrides = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDeviceType() != null) {
            sb.append("DeviceType: ").append(this.getDeviceType()).append(",");
        }
        if (this.getCallbackOverrides() != null) {
            sb.append("CallbackOverrides: ").append(this.getCallbackOverrides());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeviceTemplate)) {
            return false;
        }
        DeviceTemplate other = (DeviceTemplate)obj;
        if (other.getDeviceType() == null ^ this.getDeviceType() == null) {
            return false;
        }
        if (other.getDeviceType() != null && !other.getDeviceType().equals(this.getDeviceType())) {
            return false;
        }
        if (other.getCallbackOverrides() == null ^ this.getCallbackOverrides() == null) {
            return false;
        }
        return other.getCallbackOverrides() == null || other.getCallbackOverrides().equals(this.getCallbackOverrides());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDeviceType() == null ? 0 : this.getDeviceType().hashCode());
        hashCode = 31 * hashCode + (this.getCallbackOverrides() == null ? 0 : this.getCallbackOverrides().hashCode());
        return hashCode;
    }

    public DeviceTemplate clone() {
        try {
            return (DeviceTemplate)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DeviceTemplateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

