/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot1clickdevices;

import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.iot1clickdevices.AWSIoT1ClickDevicesAsync;
import com.amazonaws.services.iot1clickdevices.AWSIoT1ClickDevicesAsyncClientBuilder;
import com.amazonaws.services.iot1clickdevices.AWSIoT1ClickDevicesClient;
import com.amazonaws.services.iot1clickdevices.model.ClaimDevicesByClaimCodeRequest;
import com.amazonaws.services.iot1clickdevices.model.ClaimDevicesByClaimCodeResult;
import com.amazonaws.services.iot1clickdevices.model.DescribeDeviceRequest;
import com.amazonaws.services.iot1clickdevices.model.DescribeDeviceResult;
import com.amazonaws.services.iot1clickdevices.model.FinalizeDeviceClaimRequest;
import com.amazonaws.services.iot1clickdevices.model.FinalizeDeviceClaimResult;
import com.amazonaws.services.iot1clickdevices.model.GetDeviceMethodsRequest;
import com.amazonaws.services.iot1clickdevices.model.GetDeviceMethodsResult;
import com.amazonaws.services.iot1clickdevices.model.InitiateDeviceClaimRequest;
import com.amazonaws.services.iot1clickdevices.model.InitiateDeviceClaimResult;
import com.amazonaws.services.iot1clickdevices.model.InvokeDeviceMethodRequest;
import com.amazonaws.services.iot1clickdevices.model.InvokeDeviceMethodResult;
import com.amazonaws.services.iot1clickdevices.model.ListDeviceEventsRequest;
import com.amazonaws.services.iot1clickdevices.model.ListDeviceEventsResult;
import com.amazonaws.services.iot1clickdevices.model.ListDevicesRequest;
import com.amazonaws.services.iot1clickdevices.model.ListDevicesResult;
import com.amazonaws.services.iot1clickdevices.model.ListTagsForResourceRequest;
import com.amazonaws.services.iot1clickdevices.model.ListTagsForResourceResult;
import com.amazonaws.services.iot1clickdevices.model.TagResourceRequest;
import com.amazonaws.services.iot1clickdevices.model.TagResourceResult;
import com.amazonaws.services.iot1clickdevices.model.UnclaimDeviceRequest;
import com.amazonaws.services.iot1clickdevices.model.UnclaimDeviceResult;
import com.amazonaws.services.iot1clickdevices.model.UntagResourceRequest;
import com.amazonaws.services.iot1clickdevices.model.UntagResourceResult;
import com.amazonaws.services.iot1clickdevices.model.UpdateDeviceStateRequest;
import com.amazonaws.services.iot1clickdevices.model.UpdateDeviceStateResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSIoT1ClickDevicesAsyncClient
extends AWSIoT1ClickDevicesClient
implements AWSIoT1ClickDevicesAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSIoT1ClickDevicesAsyncClientBuilder asyncBuilder() {
        return AWSIoT1ClickDevicesAsyncClientBuilder.standard();
    }

    AWSIoT1ClickDevicesAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super(asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<ClaimDevicesByClaimCodeResult> claimDevicesByClaimCodeAsync(ClaimDevicesByClaimCodeRequest request) {
        return this.claimDevicesByClaimCodeAsync(request, null);
    }

    @Override
    public Future<ClaimDevicesByClaimCodeResult> claimDevicesByClaimCodeAsync(ClaimDevicesByClaimCodeRequest request, final AsyncHandler<ClaimDevicesByClaimCodeRequest, ClaimDevicesByClaimCodeResult> asyncHandler) {
        final ClaimDevicesByClaimCodeRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ClaimDevicesByClaimCodeResult>(){

            @Override
            public ClaimDevicesByClaimCodeResult call() throws Exception {
                ClaimDevicesByClaimCodeResult result = null;
                try {
                    result = AWSIoT1ClickDevicesAsyncClient.this.executeClaimDevicesByClaimCode(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeDeviceResult> describeDeviceAsync(DescribeDeviceRequest request) {
        return this.describeDeviceAsync(request, null);
    }

    @Override
    public Future<DescribeDeviceResult> describeDeviceAsync(DescribeDeviceRequest request, final AsyncHandler<DescribeDeviceRequest, DescribeDeviceResult> asyncHandler) {
        final DescribeDeviceRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeDeviceResult>(){

            @Override
            public DescribeDeviceResult call() throws Exception {
                DescribeDeviceResult result = null;
                try {
                    result = AWSIoT1ClickDevicesAsyncClient.this.executeDescribeDevice(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<FinalizeDeviceClaimResult> finalizeDeviceClaimAsync(FinalizeDeviceClaimRequest request) {
        return this.finalizeDeviceClaimAsync(request, null);
    }

    @Override
    public Future<FinalizeDeviceClaimResult> finalizeDeviceClaimAsync(FinalizeDeviceClaimRequest request, final AsyncHandler<FinalizeDeviceClaimRequest, FinalizeDeviceClaimResult> asyncHandler) {
        final FinalizeDeviceClaimRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<FinalizeDeviceClaimResult>(){

            @Override
            public FinalizeDeviceClaimResult call() throws Exception {
                FinalizeDeviceClaimResult result = null;
                try {
                    result = AWSIoT1ClickDevicesAsyncClient.this.executeFinalizeDeviceClaim(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetDeviceMethodsResult> getDeviceMethodsAsync(GetDeviceMethodsRequest request) {
        return this.getDeviceMethodsAsync(request, null);
    }

    @Override
    public Future<GetDeviceMethodsResult> getDeviceMethodsAsync(GetDeviceMethodsRequest request, final AsyncHandler<GetDeviceMethodsRequest, GetDeviceMethodsResult> asyncHandler) {
        final GetDeviceMethodsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetDeviceMethodsResult>(){

            @Override
            public GetDeviceMethodsResult call() throws Exception {
                GetDeviceMethodsResult result = null;
                try {
                    result = AWSIoT1ClickDevicesAsyncClient.this.executeGetDeviceMethods(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<InitiateDeviceClaimResult> initiateDeviceClaimAsync(InitiateDeviceClaimRequest request) {
        return this.initiateDeviceClaimAsync(request, null);
    }

    @Override
    public Future<InitiateDeviceClaimResult> initiateDeviceClaimAsync(InitiateDeviceClaimRequest request, final AsyncHandler<InitiateDeviceClaimRequest, InitiateDeviceClaimResult> asyncHandler) {
        final InitiateDeviceClaimRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<InitiateDeviceClaimResult>(){

            @Override
            public InitiateDeviceClaimResult call() throws Exception {
                InitiateDeviceClaimResult result = null;
                try {
                    result = AWSIoT1ClickDevicesAsyncClient.this.executeInitiateDeviceClaim(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<InvokeDeviceMethodResult> invokeDeviceMethodAsync(InvokeDeviceMethodRequest request) {
        return this.invokeDeviceMethodAsync(request, null);
    }

    @Override
    public Future<InvokeDeviceMethodResult> invokeDeviceMethodAsync(InvokeDeviceMethodRequest request, final AsyncHandler<InvokeDeviceMethodRequest, InvokeDeviceMethodResult> asyncHandler) {
        final InvokeDeviceMethodRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<InvokeDeviceMethodResult>(){

            @Override
            public InvokeDeviceMethodResult call() throws Exception {
                InvokeDeviceMethodResult result = null;
                try {
                    result = AWSIoT1ClickDevicesAsyncClient.this.executeInvokeDeviceMethod(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListDeviceEventsResult> listDeviceEventsAsync(ListDeviceEventsRequest request) {
        return this.listDeviceEventsAsync(request, null);
    }

    @Override
    public Future<ListDeviceEventsResult> listDeviceEventsAsync(ListDeviceEventsRequest request, final AsyncHandler<ListDeviceEventsRequest, ListDeviceEventsResult> asyncHandler) {
        final ListDeviceEventsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListDeviceEventsResult>(){

            @Override
            public ListDeviceEventsResult call() throws Exception {
                ListDeviceEventsResult result = null;
                try {
                    result = AWSIoT1ClickDevicesAsyncClient.this.executeListDeviceEvents(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListDevicesResult> listDevicesAsync(ListDevicesRequest request) {
        return this.listDevicesAsync(request, null);
    }

    @Override
    public Future<ListDevicesResult> listDevicesAsync(ListDevicesRequest request, final AsyncHandler<ListDevicesRequest, ListDevicesResult> asyncHandler) {
        final ListDevicesRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListDevicesResult>(){

            @Override
            public ListDevicesResult call() throws Exception {
                ListDevicesResult result = null;
                try {
                    result = AWSIoT1ClickDevicesAsyncClient.this.executeListDevices(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AWSIoT1ClickDevicesAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AWSIoT1ClickDevicesAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UnclaimDeviceResult> unclaimDeviceAsync(UnclaimDeviceRequest request) {
        return this.unclaimDeviceAsync(request, null);
    }

    @Override
    public Future<UnclaimDeviceResult> unclaimDeviceAsync(UnclaimDeviceRequest request, final AsyncHandler<UnclaimDeviceRequest, UnclaimDeviceResult> asyncHandler) {
        final UnclaimDeviceRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UnclaimDeviceResult>(){

            @Override
            public UnclaimDeviceResult call() throws Exception {
                UnclaimDeviceResult result = null;
                try {
                    result = AWSIoT1ClickDevicesAsyncClient.this.executeUnclaimDevice(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AWSIoT1ClickDevicesAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateDeviceStateResult> updateDeviceStateAsync(UpdateDeviceStateRequest request) {
        return this.updateDeviceStateAsync(request, null);
    }

    @Override
    public Future<UpdateDeviceStateResult> updateDeviceStateAsync(UpdateDeviceStateRequest request, final AsyncHandler<UpdateDeviceStateRequest, UpdateDeviceStateResult> asyncHandler) {
        final UpdateDeviceStateRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateDeviceStateResult>(){

            @Override
            public UpdateDeviceStateResult call() throws Exception {
                UpdateDeviceStateResult result = null;
                try {
                    result = AWSIoT1ClickDevicesAsyncClient.this.executeUpdateDeviceState(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

