/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.groundstation.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.groundstation.model.ReserveContactRequest;
import java.util.Date;
import java.util.Map;

@SdkInternalApi
public class ReserveContactRequestMarshaller {
    private static final MarshallingInfo<Date> ENDTIME_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("endTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> GROUNDSTATION_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("groundStation").build();
    private static final MarshallingInfo<String> MISSIONPROFILEARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("missionProfileArn").build();
    private static final MarshallingInfo<String> SATELLITEARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("satelliteArn").build();
    private static final MarshallingInfo<Date> STARTTIME_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("startTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Map> TAGS_BINDING = MarshallingInfo.builder(MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("tags").build();
    private static final ReserveContactRequestMarshaller instance = new ReserveContactRequestMarshaller();

    public static ReserveContactRequestMarshaller getInstance() {
        return instance;
    }

    public void marshall(ReserveContactRequest reserveContactRequest, ProtocolMarshaller protocolMarshaller) {
        if (reserveContactRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(reserveContactRequest.getEndTime(), ENDTIME_BINDING);
            protocolMarshaller.marshall(reserveContactRequest.getGroundStation(), GROUNDSTATION_BINDING);
            protocolMarshaller.marshall(reserveContactRequest.getMissionProfileArn(), MISSIONPROFILEARN_BINDING);
            protocolMarshaller.marshall(reserveContactRequest.getSatelliteArn(), SATELLITEARN_BINDING);
            protocolMarshaller.marshall(reserveContactRequest.getStartTime(), STARTTIME_BINDING);
            protocolMarshaller.marshall(reserveContactRequest.getTags(), TAGS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

