/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.groundstation.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.groundstation.model.DataflowEndpoint;

@SdkInternalApi
public class DataflowEndpointMarshaller {
    private static final MarshallingInfo<StructuredPojo> ADDRESS_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("address").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").build();
    private static final DataflowEndpointMarshaller instance = new DataflowEndpointMarshaller();

    public static DataflowEndpointMarshaller getInstance() {
        return instance;
    }

    public void marshall(DataflowEndpoint dataflowEndpoint, ProtocolMarshaller protocolMarshaller) {
        if (dataflowEndpoint == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(dataflowEndpoint.getAddress(), ADDRESS_BINDING);
            protocolMarshaller.marshall(dataflowEndpoint.getName(), NAME_BINDING);
            protocolMarshaller.marshall(dataflowEndpoint.getStatus(), STATUS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

