/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.fsx.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.fsx.model.DataRepositoryConfiguration;

@SdkInternalApi
public class DataRepositoryConfigurationMarshaller {
    private static final MarshallingInfo<String> IMPORTPATH_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ImportPath").build();
    private static final MarshallingInfo<String> EXPORTPATH_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExportPath").build();
    private static final MarshallingInfo<Integer> IMPORTEDFILECHUNKSIZE_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ImportedFileChunkSize").build();
    private static final DataRepositoryConfigurationMarshaller instance = new DataRepositoryConfigurationMarshaller();

    public static DataRepositoryConfigurationMarshaller getInstance() {
        return instance;
    }

    public void marshall(DataRepositoryConfiguration dataRepositoryConfiguration, ProtocolMarshaller protocolMarshaller) {
        if (dataRepositoryConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(dataRepositoryConfiguration.getImportPath(), IMPORTPATH_BINDING);
            protocolMarshaller.marshall(dataRepositoryConfiguration.getExportPath(), EXPORTPATH_BINDING);
            protocolMarshaller.marshall(dataRepositoryConfiguration.getImportedFileChunkSize(), IMPORTEDFILECHUNKSIZE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

