/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.fsx.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.fsx.model.transform.DataRepositoryConfigurationMarshaller;
import java.io.Serializable;

public class DataRepositoryConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private String importPath;
    private String exportPath;
    private Integer importedFileChunkSize;

    public void setImportPath(String importPath) {
        this.importPath = importPath;
    }

    public String getImportPath() {
        return this.importPath;
    }

    public DataRepositoryConfiguration withImportPath(String importPath) {
        this.setImportPath(importPath);
        return this;
    }

    public void setExportPath(String exportPath) {
        this.exportPath = exportPath;
    }

    public String getExportPath() {
        return this.exportPath;
    }

    public DataRepositoryConfiguration withExportPath(String exportPath) {
        this.setExportPath(exportPath);
        return this;
    }

    public void setImportedFileChunkSize(Integer importedFileChunkSize) {
        this.importedFileChunkSize = importedFileChunkSize;
    }

    public Integer getImportedFileChunkSize() {
        return this.importedFileChunkSize;
    }

    public DataRepositoryConfiguration withImportedFileChunkSize(Integer importedFileChunkSize) {
        this.setImportedFileChunkSize(importedFileChunkSize);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getImportPath() != null) {
            sb.append("ImportPath: ").append(this.getImportPath()).append(",");
        }
        if (this.getExportPath() != null) {
            sb.append("ExportPath: ").append(this.getExportPath()).append(",");
        }
        if (this.getImportedFileChunkSize() != null) {
            sb.append("ImportedFileChunkSize: ").append(this.getImportedFileChunkSize());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataRepositoryConfiguration)) {
            return false;
        }
        DataRepositoryConfiguration other = (DataRepositoryConfiguration)obj;
        if (other.getImportPath() == null ^ this.getImportPath() == null) {
            return false;
        }
        if (other.getImportPath() != null && !other.getImportPath().equals(this.getImportPath())) {
            return false;
        }
        if (other.getExportPath() == null ^ this.getExportPath() == null) {
            return false;
        }
        if (other.getExportPath() != null && !other.getExportPath().equals(this.getExportPath())) {
            return false;
        }
        if (other.getImportedFileChunkSize() == null ^ this.getImportedFileChunkSize() == null) {
            return false;
        }
        return other.getImportedFileChunkSize() == null || other.getImportedFileChunkSize().equals(this.getImportedFileChunkSize());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getImportPath() == null ? 0 : this.getImportPath().hashCode());
        hashCode = 31 * hashCode + (this.getExportPath() == null ? 0 : this.getExportPath().hashCode());
        hashCode = 31 * hashCode + (this.getImportedFileChunkSize() == null ? 0 : this.getImportedFileChunkSize().hashCode());
        return hashCode;
    }

    public DataRepositoryConfiguration clone() {
        try {
            return (DataRepositoryConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DataRepositoryConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

