/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.fms.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.fms.model.ResourceTag;
import com.amazonaws.services.fms.model.SecurityServicePolicyData;
import com.amazonaws.services.fms.model.transform.PolicyMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Policy
implements Serializable,
Cloneable,
StructuredPojo {
    private String policyId;
    private String policyName;
    private String policyUpdateToken;
    private SecurityServicePolicyData securityServicePolicyData;
    private String resourceType;
    private List<String> resourceTypeList;
    private List<ResourceTag> resourceTags;
    private Boolean excludeResourceTags;
    private Boolean remediationEnabled;
    private Map<String, List<String>> includeMap;
    private Map<String, List<String>> excludeMap;

    public void setPolicyId(String policyId) {
        this.policyId = policyId;
    }

    public String getPolicyId() {
        return this.policyId;
    }

    public Policy withPolicyId(String policyId) {
        this.setPolicyId(policyId);
        return this;
    }

    public void setPolicyName(String policyName) {
        this.policyName = policyName;
    }

    public String getPolicyName() {
        return this.policyName;
    }

    public Policy withPolicyName(String policyName) {
        this.setPolicyName(policyName);
        return this;
    }

    public void setPolicyUpdateToken(String policyUpdateToken) {
        this.policyUpdateToken = policyUpdateToken;
    }

    public String getPolicyUpdateToken() {
        return this.policyUpdateToken;
    }

    public Policy withPolicyUpdateToken(String policyUpdateToken) {
        this.setPolicyUpdateToken(policyUpdateToken);
        return this;
    }

    public void setSecurityServicePolicyData(SecurityServicePolicyData securityServicePolicyData) {
        this.securityServicePolicyData = securityServicePolicyData;
    }

    public SecurityServicePolicyData getSecurityServicePolicyData() {
        return this.securityServicePolicyData;
    }

    public Policy withSecurityServicePolicyData(SecurityServicePolicyData securityServicePolicyData) {
        this.setSecurityServicePolicyData(securityServicePolicyData);
        return this;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public Policy withResourceType(String resourceType) {
        this.setResourceType(resourceType);
        return this;
    }

    public List<String> getResourceTypeList() {
        return this.resourceTypeList;
    }

    public void setResourceTypeList(Collection<String> resourceTypeList) {
        if (resourceTypeList == null) {
            this.resourceTypeList = null;
            return;
        }
        this.resourceTypeList = new ArrayList<String>(resourceTypeList);
    }

    public Policy withResourceTypeList(String ... resourceTypeList) {
        if (this.resourceTypeList == null) {
            this.setResourceTypeList(new ArrayList<String>(resourceTypeList.length));
        }
        for (String ele : resourceTypeList) {
            this.resourceTypeList.add(ele);
        }
        return this;
    }

    public Policy withResourceTypeList(Collection<String> resourceTypeList) {
        this.setResourceTypeList(resourceTypeList);
        return this;
    }

    public List<ResourceTag> getResourceTags() {
        return this.resourceTags;
    }

    public void setResourceTags(Collection<ResourceTag> resourceTags) {
        if (resourceTags == null) {
            this.resourceTags = null;
            return;
        }
        this.resourceTags = new ArrayList<ResourceTag>(resourceTags);
    }

    public Policy withResourceTags(ResourceTag ... resourceTags) {
        if (this.resourceTags == null) {
            this.setResourceTags(new ArrayList<ResourceTag>(resourceTags.length));
        }
        for (ResourceTag ele : resourceTags) {
            this.resourceTags.add(ele);
        }
        return this;
    }

    public Policy withResourceTags(Collection<ResourceTag> resourceTags) {
        this.setResourceTags(resourceTags);
        return this;
    }

    public void setExcludeResourceTags(Boolean excludeResourceTags) {
        this.excludeResourceTags = excludeResourceTags;
    }

    public Boolean getExcludeResourceTags() {
        return this.excludeResourceTags;
    }

    public Policy withExcludeResourceTags(Boolean excludeResourceTags) {
        this.setExcludeResourceTags(excludeResourceTags);
        return this;
    }

    public Boolean isExcludeResourceTags() {
        return this.excludeResourceTags;
    }

    public void setRemediationEnabled(Boolean remediationEnabled) {
        this.remediationEnabled = remediationEnabled;
    }

    public Boolean getRemediationEnabled() {
        return this.remediationEnabled;
    }

    public Policy withRemediationEnabled(Boolean remediationEnabled) {
        this.setRemediationEnabled(remediationEnabled);
        return this;
    }

    public Boolean isRemediationEnabled() {
        return this.remediationEnabled;
    }

    public Map<String, List<String>> getIncludeMap() {
        return this.includeMap;
    }

    public void setIncludeMap(Map<String, List<String>> includeMap) {
        this.includeMap = includeMap;
    }

    public Policy withIncludeMap(Map<String, List<String>> includeMap) {
        this.setIncludeMap(includeMap);
        return this;
    }

    public Policy addIncludeMapEntry(String key, List<String> value) {
        if (null == this.includeMap) {
            this.includeMap = new HashMap<String, List<String>>();
        }
        if (this.includeMap.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.includeMap.put(key, value);
        return this;
    }

    public Policy clearIncludeMapEntries() {
        this.includeMap = null;
        return this;
    }

    public Map<String, List<String>> getExcludeMap() {
        return this.excludeMap;
    }

    public void setExcludeMap(Map<String, List<String>> excludeMap) {
        this.excludeMap = excludeMap;
    }

    public Policy withExcludeMap(Map<String, List<String>> excludeMap) {
        this.setExcludeMap(excludeMap);
        return this;
    }

    public Policy addExcludeMapEntry(String key, List<String> value) {
        if (null == this.excludeMap) {
            this.excludeMap = new HashMap<String, List<String>>();
        }
        if (this.excludeMap.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.excludeMap.put(key, value);
        return this;
    }

    public Policy clearExcludeMapEntries() {
        this.excludeMap = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPolicyId() != null) {
            sb.append("PolicyId: ").append(this.getPolicyId()).append(",");
        }
        if (this.getPolicyName() != null) {
            sb.append("PolicyName: ").append(this.getPolicyName()).append(",");
        }
        if (this.getPolicyUpdateToken() != null) {
            sb.append("PolicyUpdateToken: ").append(this.getPolicyUpdateToken()).append(",");
        }
        if (this.getSecurityServicePolicyData() != null) {
            sb.append("SecurityServicePolicyData: ").append(this.getSecurityServicePolicyData()).append(",");
        }
        if (this.getResourceType() != null) {
            sb.append("ResourceType: ").append(this.getResourceType()).append(",");
        }
        if (this.getResourceTypeList() != null) {
            sb.append("ResourceTypeList: ").append(this.getResourceTypeList()).append(",");
        }
        if (this.getResourceTags() != null) {
            sb.append("ResourceTags: ").append(this.getResourceTags()).append(",");
        }
        if (this.getExcludeResourceTags() != null) {
            sb.append("ExcludeResourceTags: ").append(this.getExcludeResourceTags()).append(",");
        }
        if (this.getRemediationEnabled() != null) {
            sb.append("RemediationEnabled: ").append(this.getRemediationEnabled()).append(",");
        }
        if (this.getIncludeMap() != null) {
            sb.append("IncludeMap: ").append(this.getIncludeMap()).append(",");
        }
        if (this.getExcludeMap() != null) {
            sb.append("ExcludeMap: ").append(this.getExcludeMap());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Policy)) {
            return false;
        }
        Policy other = (Policy)obj;
        if (other.getPolicyId() == null ^ this.getPolicyId() == null) {
            return false;
        }
        if (other.getPolicyId() != null && !other.getPolicyId().equals(this.getPolicyId())) {
            return false;
        }
        if (other.getPolicyName() == null ^ this.getPolicyName() == null) {
            return false;
        }
        if (other.getPolicyName() != null && !other.getPolicyName().equals(this.getPolicyName())) {
            return false;
        }
        if (other.getPolicyUpdateToken() == null ^ this.getPolicyUpdateToken() == null) {
            return false;
        }
        if (other.getPolicyUpdateToken() != null && !other.getPolicyUpdateToken().equals(this.getPolicyUpdateToken())) {
            return false;
        }
        if (other.getSecurityServicePolicyData() == null ^ this.getSecurityServicePolicyData() == null) {
            return false;
        }
        if (other.getSecurityServicePolicyData() != null && !other.getSecurityServicePolicyData().equals(this.getSecurityServicePolicyData())) {
            return false;
        }
        if (other.getResourceType() == null ^ this.getResourceType() == null) {
            return false;
        }
        if (other.getResourceType() != null && !other.getResourceType().equals(this.getResourceType())) {
            return false;
        }
        if (other.getResourceTypeList() == null ^ this.getResourceTypeList() == null) {
            return false;
        }
        if (other.getResourceTypeList() != null && !other.getResourceTypeList().equals(this.getResourceTypeList())) {
            return false;
        }
        if (other.getResourceTags() == null ^ this.getResourceTags() == null) {
            return false;
        }
        if (other.getResourceTags() != null && !other.getResourceTags().equals(this.getResourceTags())) {
            return false;
        }
        if (other.getExcludeResourceTags() == null ^ this.getExcludeResourceTags() == null) {
            return false;
        }
        if (other.getExcludeResourceTags() != null && !other.getExcludeResourceTags().equals(this.getExcludeResourceTags())) {
            return false;
        }
        if (other.getRemediationEnabled() == null ^ this.getRemediationEnabled() == null) {
            return false;
        }
        if (other.getRemediationEnabled() != null && !other.getRemediationEnabled().equals(this.getRemediationEnabled())) {
            return false;
        }
        if (other.getIncludeMap() == null ^ this.getIncludeMap() == null) {
            return false;
        }
        if (other.getIncludeMap() != null && !other.getIncludeMap().equals(this.getIncludeMap())) {
            return false;
        }
        if (other.getExcludeMap() == null ^ this.getExcludeMap() == null) {
            return false;
        }
        return other.getExcludeMap() == null || other.getExcludeMap().equals(this.getExcludeMap());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPolicyId() == null ? 0 : this.getPolicyId().hashCode());
        hashCode = 31 * hashCode + (this.getPolicyName() == null ? 0 : this.getPolicyName().hashCode());
        hashCode = 31 * hashCode + (this.getPolicyUpdateToken() == null ? 0 : this.getPolicyUpdateToken().hashCode());
        hashCode = 31 * hashCode + (this.getSecurityServicePolicyData() == null ? 0 : this.getSecurityServicePolicyData().hashCode());
        hashCode = 31 * hashCode + (this.getResourceType() == null ? 0 : this.getResourceType().hashCode());
        hashCode = 31 * hashCode + (this.getResourceTypeList() == null ? 0 : this.getResourceTypeList().hashCode());
        hashCode = 31 * hashCode + (this.getResourceTags() == null ? 0 : this.getResourceTags().hashCode());
        hashCode = 31 * hashCode + (this.getExcludeResourceTags() == null ? 0 : this.getExcludeResourceTags().hashCode());
        hashCode = 31 * hashCode + (this.getRemediationEnabled() == null ? 0 : this.getRemediationEnabled().hashCode());
        hashCode = 31 * hashCode + (this.getIncludeMap() == null ? 0 : this.getIncludeMap().hashCode());
        hashCode = 31 * hashCode + (this.getExcludeMap() == null ? 0 : this.getExcludeMap().hashCode());
        return hashCode;
    }

    public Policy clone() {
        try {
            return (Policy)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PolicyMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

