/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.fms;

import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.fms.AWSFMSAsync;
import com.amazonaws.services.fms.AWSFMSAsyncClientBuilder;
import com.amazonaws.services.fms.AWSFMSClient;
import com.amazonaws.services.fms.model.AssociateAdminAccountRequest;
import com.amazonaws.services.fms.model.AssociateAdminAccountResult;
import com.amazonaws.services.fms.model.DeleteNotificationChannelRequest;
import com.amazonaws.services.fms.model.DeleteNotificationChannelResult;
import com.amazonaws.services.fms.model.DeletePolicyRequest;
import com.amazonaws.services.fms.model.DeletePolicyResult;
import com.amazonaws.services.fms.model.DisassociateAdminAccountRequest;
import com.amazonaws.services.fms.model.DisassociateAdminAccountResult;
import com.amazonaws.services.fms.model.GetAdminAccountRequest;
import com.amazonaws.services.fms.model.GetAdminAccountResult;
import com.amazonaws.services.fms.model.GetComplianceDetailRequest;
import com.amazonaws.services.fms.model.GetComplianceDetailResult;
import com.amazonaws.services.fms.model.GetNotificationChannelRequest;
import com.amazonaws.services.fms.model.GetNotificationChannelResult;
import com.amazonaws.services.fms.model.GetPolicyRequest;
import com.amazonaws.services.fms.model.GetPolicyResult;
import com.amazonaws.services.fms.model.GetProtectionStatusRequest;
import com.amazonaws.services.fms.model.GetProtectionStatusResult;
import com.amazonaws.services.fms.model.ListComplianceStatusRequest;
import com.amazonaws.services.fms.model.ListComplianceStatusResult;
import com.amazonaws.services.fms.model.ListMemberAccountsRequest;
import com.amazonaws.services.fms.model.ListMemberAccountsResult;
import com.amazonaws.services.fms.model.ListPoliciesRequest;
import com.amazonaws.services.fms.model.ListPoliciesResult;
import com.amazonaws.services.fms.model.PutNotificationChannelRequest;
import com.amazonaws.services.fms.model.PutNotificationChannelResult;
import com.amazonaws.services.fms.model.PutPolicyRequest;
import com.amazonaws.services.fms.model.PutPolicyResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSFMSAsyncClient
extends AWSFMSClient
implements AWSFMSAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSFMSAsyncClientBuilder asyncBuilder() {
        return AWSFMSAsyncClientBuilder.standard();
    }

    AWSFMSAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super(asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<AssociateAdminAccountResult> associateAdminAccountAsync(AssociateAdminAccountRequest request) {
        return this.associateAdminAccountAsync(request, null);
    }

    @Override
    public Future<AssociateAdminAccountResult> associateAdminAccountAsync(AssociateAdminAccountRequest request, final AsyncHandler<AssociateAdminAccountRequest, AssociateAdminAccountResult> asyncHandler) {
        final AssociateAdminAccountRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<AssociateAdminAccountResult>(){

            @Override
            public AssociateAdminAccountResult call() throws Exception {
                AssociateAdminAccountResult result = null;
                try {
                    result = AWSFMSAsyncClient.this.executeAssociateAdminAccount(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteNotificationChannelResult> deleteNotificationChannelAsync(DeleteNotificationChannelRequest request) {
        return this.deleteNotificationChannelAsync(request, null);
    }

    @Override
    public Future<DeleteNotificationChannelResult> deleteNotificationChannelAsync(DeleteNotificationChannelRequest request, final AsyncHandler<DeleteNotificationChannelRequest, DeleteNotificationChannelResult> asyncHandler) {
        final DeleteNotificationChannelRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteNotificationChannelResult>(){

            @Override
            public DeleteNotificationChannelResult call() throws Exception {
                DeleteNotificationChannelResult result = null;
                try {
                    result = AWSFMSAsyncClient.this.executeDeleteNotificationChannel(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeletePolicyResult> deletePolicyAsync(DeletePolicyRequest request) {
        return this.deletePolicyAsync(request, null);
    }

    @Override
    public Future<DeletePolicyResult> deletePolicyAsync(DeletePolicyRequest request, final AsyncHandler<DeletePolicyRequest, DeletePolicyResult> asyncHandler) {
        final DeletePolicyRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeletePolicyResult>(){

            @Override
            public DeletePolicyResult call() throws Exception {
                DeletePolicyResult result = null;
                try {
                    result = AWSFMSAsyncClient.this.executeDeletePolicy(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DisassociateAdminAccountResult> disassociateAdminAccountAsync(DisassociateAdminAccountRequest request) {
        return this.disassociateAdminAccountAsync(request, null);
    }

    @Override
    public Future<DisassociateAdminAccountResult> disassociateAdminAccountAsync(DisassociateAdminAccountRequest request, final AsyncHandler<DisassociateAdminAccountRequest, DisassociateAdminAccountResult> asyncHandler) {
        final DisassociateAdminAccountRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DisassociateAdminAccountResult>(){

            @Override
            public DisassociateAdminAccountResult call() throws Exception {
                DisassociateAdminAccountResult result = null;
                try {
                    result = AWSFMSAsyncClient.this.executeDisassociateAdminAccount(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetAdminAccountResult> getAdminAccountAsync(GetAdminAccountRequest request) {
        return this.getAdminAccountAsync(request, null);
    }

    @Override
    public Future<GetAdminAccountResult> getAdminAccountAsync(GetAdminAccountRequest request, final AsyncHandler<GetAdminAccountRequest, GetAdminAccountResult> asyncHandler) {
        final GetAdminAccountRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetAdminAccountResult>(){

            @Override
            public GetAdminAccountResult call() throws Exception {
                GetAdminAccountResult result = null;
                try {
                    result = AWSFMSAsyncClient.this.executeGetAdminAccount(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetComplianceDetailResult> getComplianceDetailAsync(GetComplianceDetailRequest request) {
        return this.getComplianceDetailAsync(request, null);
    }

    @Override
    public Future<GetComplianceDetailResult> getComplianceDetailAsync(GetComplianceDetailRequest request, final AsyncHandler<GetComplianceDetailRequest, GetComplianceDetailResult> asyncHandler) {
        final GetComplianceDetailRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetComplianceDetailResult>(){

            @Override
            public GetComplianceDetailResult call() throws Exception {
                GetComplianceDetailResult result = null;
                try {
                    result = AWSFMSAsyncClient.this.executeGetComplianceDetail(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetNotificationChannelResult> getNotificationChannelAsync(GetNotificationChannelRequest request) {
        return this.getNotificationChannelAsync(request, null);
    }

    @Override
    public Future<GetNotificationChannelResult> getNotificationChannelAsync(GetNotificationChannelRequest request, final AsyncHandler<GetNotificationChannelRequest, GetNotificationChannelResult> asyncHandler) {
        final GetNotificationChannelRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetNotificationChannelResult>(){

            @Override
            public GetNotificationChannelResult call() throws Exception {
                GetNotificationChannelResult result = null;
                try {
                    result = AWSFMSAsyncClient.this.executeGetNotificationChannel(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetPolicyResult> getPolicyAsync(GetPolicyRequest request) {
        return this.getPolicyAsync(request, null);
    }

    @Override
    public Future<GetPolicyResult> getPolicyAsync(GetPolicyRequest request, final AsyncHandler<GetPolicyRequest, GetPolicyResult> asyncHandler) {
        final GetPolicyRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetPolicyResult>(){

            @Override
            public GetPolicyResult call() throws Exception {
                GetPolicyResult result = null;
                try {
                    result = AWSFMSAsyncClient.this.executeGetPolicy(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetProtectionStatusResult> getProtectionStatusAsync(GetProtectionStatusRequest request) {
        return this.getProtectionStatusAsync(request, null);
    }

    @Override
    public Future<GetProtectionStatusResult> getProtectionStatusAsync(GetProtectionStatusRequest request, final AsyncHandler<GetProtectionStatusRequest, GetProtectionStatusResult> asyncHandler) {
        final GetProtectionStatusRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetProtectionStatusResult>(){

            @Override
            public GetProtectionStatusResult call() throws Exception {
                GetProtectionStatusResult result = null;
                try {
                    result = AWSFMSAsyncClient.this.executeGetProtectionStatus(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListComplianceStatusResult> listComplianceStatusAsync(ListComplianceStatusRequest request) {
        return this.listComplianceStatusAsync(request, null);
    }

    @Override
    public Future<ListComplianceStatusResult> listComplianceStatusAsync(ListComplianceStatusRequest request, final AsyncHandler<ListComplianceStatusRequest, ListComplianceStatusResult> asyncHandler) {
        final ListComplianceStatusRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListComplianceStatusResult>(){

            @Override
            public ListComplianceStatusResult call() throws Exception {
                ListComplianceStatusResult result = null;
                try {
                    result = AWSFMSAsyncClient.this.executeListComplianceStatus(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListMemberAccountsResult> listMemberAccountsAsync(ListMemberAccountsRequest request) {
        return this.listMemberAccountsAsync(request, null);
    }

    @Override
    public Future<ListMemberAccountsResult> listMemberAccountsAsync(ListMemberAccountsRequest request, final AsyncHandler<ListMemberAccountsRequest, ListMemberAccountsResult> asyncHandler) {
        final ListMemberAccountsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListMemberAccountsResult>(){

            @Override
            public ListMemberAccountsResult call() throws Exception {
                ListMemberAccountsResult result = null;
                try {
                    result = AWSFMSAsyncClient.this.executeListMemberAccounts(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListPoliciesResult> listPoliciesAsync(ListPoliciesRequest request) {
        return this.listPoliciesAsync(request, null);
    }

    @Override
    public Future<ListPoliciesResult> listPoliciesAsync(ListPoliciesRequest request, final AsyncHandler<ListPoliciesRequest, ListPoliciesResult> asyncHandler) {
        final ListPoliciesRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListPoliciesResult>(){

            @Override
            public ListPoliciesResult call() throws Exception {
                ListPoliciesResult result = null;
                try {
                    result = AWSFMSAsyncClient.this.executeListPolicies(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutNotificationChannelResult> putNotificationChannelAsync(PutNotificationChannelRequest request) {
        return this.putNotificationChannelAsync(request, null);
    }

    @Override
    public Future<PutNotificationChannelResult> putNotificationChannelAsync(PutNotificationChannelRequest request, final AsyncHandler<PutNotificationChannelRequest, PutNotificationChannelResult> asyncHandler) {
        final PutNotificationChannelRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutNotificationChannelResult>(){

            @Override
            public PutNotificationChannelResult call() throws Exception {
                PutNotificationChannelResult result = null;
                try {
                    result = AWSFMSAsyncClient.this.executePutNotificationChannel(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutPolicyResult> putPolicyAsync(PutPolicyRequest request) {
        return this.putPolicyAsync(request, null);
    }

    @Override
    public Future<PutPolicyResult> putPolicyAsync(PutPolicyRequest request, final AsyncHandler<PutPolicyRequest, PutPolicyResult> asyncHandler) {
        final PutPolicyRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutPolicyResult>(){

            @Override
            public PutPolicyResult call() throws Exception {
                PutPolicyResult result = null;
                try {
                    result = AWSFMSAsyncClient.this.executePutPolicy(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

