/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.eks.waiters;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.jmespath.JmesPathEvaluationVisitor;
import com.amazonaws.jmespath.JmesPathExpression;
import com.amazonaws.jmespath.JmesPathField;
import com.amazonaws.jmespath.JmesPathSubExpression;
import com.amazonaws.jmespath.ObjectMapperSingleton;
import com.amazonaws.services.eks.model.DescribeClusterResult;
import com.amazonaws.thirdparty.jackson.databind.JsonNode;
import com.amazonaws.waiters.AcceptorPathMatcher;
import com.amazonaws.waiters.WaiterAcceptor;
import com.amazonaws.waiters.WaiterState;
import java.io.IOException;

@SdkInternalApi
class ClusterActive {
    ClusterActive() {
    }

    static class IsACTIVEMatcher
    extends WaiterAcceptor<DescribeClusterResult> {
        private static final JsonNode expectedResult;
        private static final JmesPathExpression ast;

        IsACTIVEMatcher() {
        }

        @Override
        public boolean matches(DescribeClusterResult result) {
            Object queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree(result);
            JsonNode finalResult = ast.accept(new JmesPathEvaluationVisitor(), queryNode);
            return AcceptorPathMatcher.path(expectedResult, finalResult);
        }

        @Override
        public WaiterState getState() {
            return WaiterState.SUCCESS;
        }

        static {
            try {
                expectedResult = ObjectMapperSingleton.getObjectMapper().readTree("\"ACTIVE\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            ast = new JmesPathSubExpression(new JmesPathField("cluster"), new JmesPathField("status"));
        }
    }

    static class IsFAILEDMatcher
    extends WaiterAcceptor<DescribeClusterResult> {
        private static final JsonNode expectedResult;
        private static final JmesPathExpression ast;

        IsFAILEDMatcher() {
        }

        @Override
        public boolean matches(DescribeClusterResult result) {
            Object queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree(result);
            JsonNode finalResult = ast.accept(new JmesPathEvaluationVisitor(), queryNode);
            return AcceptorPathMatcher.path(expectedResult, finalResult);
        }

        @Override
        public WaiterState getState() {
            return WaiterState.FAILURE;
        }

        static {
            try {
                expectedResult = ObjectMapperSingleton.getObjectMapper().readTree("\"FAILED\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            ast = new JmesPathSubExpression(new JmesPathField("cluster"), new JmesPathField("status"));
        }
    }

    static class IsDELETINGMatcher
    extends WaiterAcceptor<DescribeClusterResult> {
        private static final JsonNode expectedResult;
        private static final JmesPathExpression ast;

        IsDELETINGMatcher() {
        }

        @Override
        public boolean matches(DescribeClusterResult result) {
            Object queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree(result);
            JsonNode finalResult = ast.accept(new JmesPathEvaluationVisitor(), queryNode);
            return AcceptorPathMatcher.path(expectedResult, finalResult);
        }

        @Override
        public WaiterState getState() {
            return WaiterState.FAILURE;
        }

        static {
            try {
                expectedResult = ObjectMapperSingleton.getObjectMapper().readTree("\"DELETING\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            ast = new JmesPathSubExpression(new JmesPathField("cluster"), new JmesPathField("status"));
        }
    }
}

