/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.docdb.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.docdb.model.RestoreDBClusterFromSnapshotRequest;
import com.amazonaws.services.docdb.model.Tag;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class RestoreDBClusterFromSnapshotRequestMarshaller
implements Marshaller<Request<RestoreDBClusterFromSnapshotRequest>, RestoreDBClusterFromSnapshotRequest> {
    @Override
    public Request<RestoreDBClusterFromSnapshotRequest> marshall(RestoreDBClusterFromSnapshotRequest restoreDBClusterFromSnapshotRequest) {
        if (restoreDBClusterFromSnapshotRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<RestoreDBClusterFromSnapshotRequest> request = new DefaultRequest<RestoreDBClusterFromSnapshotRequest>(restoreDBClusterFromSnapshotRequest, "AmazonDocDB");
        request.addParameter("Action", "RestoreDBClusterFromSnapshot");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (restoreDBClusterFromSnapshotRequest.getAvailabilityZones() != null) {
            List<String> availabilityZonesList = restoreDBClusterFromSnapshotRequest.getAvailabilityZones();
            if (availabilityZonesList.isEmpty()) {
                request.addParameter("AvailabilityZones", "");
            } else {
                int availabilityZonesListIndex = 1;
                for (String availabilityZonesListValue : availabilityZonesList) {
                    if (availabilityZonesListValue != null) {
                        request.addParameter("AvailabilityZones.AvailabilityZone." + availabilityZonesListIndex, StringUtils.fromString(availabilityZonesListValue));
                    }
                    ++availabilityZonesListIndex;
                }
            }
        }
        if (restoreDBClusterFromSnapshotRequest.getDBClusterIdentifier() != null) {
            request.addParameter("DBClusterIdentifier", StringUtils.fromString(restoreDBClusterFromSnapshotRequest.getDBClusterIdentifier()));
        }
        if (restoreDBClusterFromSnapshotRequest.getSnapshotIdentifier() != null) {
            request.addParameter("SnapshotIdentifier", StringUtils.fromString(restoreDBClusterFromSnapshotRequest.getSnapshotIdentifier()));
        }
        if (restoreDBClusterFromSnapshotRequest.getEngine() != null) {
            request.addParameter("Engine", StringUtils.fromString(restoreDBClusterFromSnapshotRequest.getEngine()));
        }
        if (restoreDBClusterFromSnapshotRequest.getEngineVersion() != null) {
            request.addParameter("EngineVersion", StringUtils.fromString(restoreDBClusterFromSnapshotRequest.getEngineVersion()));
        }
        if (restoreDBClusterFromSnapshotRequest.getPort() != null) {
            request.addParameter("Port", StringUtils.fromInteger(restoreDBClusterFromSnapshotRequest.getPort()));
        }
        if (restoreDBClusterFromSnapshotRequest.getDBSubnetGroupName() != null) {
            request.addParameter("DBSubnetGroupName", StringUtils.fromString(restoreDBClusterFromSnapshotRequest.getDBSubnetGroupName()));
        }
        if (restoreDBClusterFromSnapshotRequest.getVpcSecurityGroupIds() != null) {
            List<String> vpcSecurityGroupIdsList = restoreDBClusterFromSnapshotRequest.getVpcSecurityGroupIds();
            if (vpcSecurityGroupIdsList.isEmpty()) {
                request.addParameter("VpcSecurityGroupIds", "");
            } else {
                int vpcSecurityGroupIdsListIndex = 1;
                for (String vpcSecurityGroupIdsListValue : vpcSecurityGroupIdsList) {
                    if (vpcSecurityGroupIdsListValue != null) {
                        request.addParameter("VpcSecurityGroupIds.VpcSecurityGroupId." + vpcSecurityGroupIdsListIndex, StringUtils.fromString(vpcSecurityGroupIdsListValue));
                    }
                    ++vpcSecurityGroupIdsListIndex;
                }
            }
        }
        if (restoreDBClusterFromSnapshotRequest.getTags() != null) {
            List<Tag> tagsList = restoreDBClusterFromSnapshotRequest.getTags();
            if (tagsList.isEmpty()) {
                request.addParameter("Tags", "");
            } else {
                int tagsListIndex = 1;
                for (Tag tagsListValue : tagsList) {
                    if (tagsListValue.getKey() != null) {
                        request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringUtils.fromString(tagsListValue.getKey()));
                    }
                    if (tagsListValue.getValue() != null) {
                        request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringUtils.fromString(tagsListValue.getValue()));
                    }
                    ++tagsListIndex;
                }
            }
        }
        if (restoreDBClusterFromSnapshotRequest.getKmsKeyId() != null) {
            request.addParameter("KmsKeyId", StringUtils.fromString(restoreDBClusterFromSnapshotRequest.getKmsKeyId()));
        }
        if (restoreDBClusterFromSnapshotRequest.getEnableCloudwatchLogsExports() != null) {
            List<String> enableCloudwatchLogsExportsList = restoreDBClusterFromSnapshotRequest.getEnableCloudwatchLogsExports();
            if (enableCloudwatchLogsExportsList.isEmpty()) {
                request.addParameter("EnableCloudwatchLogsExports", "");
            } else {
                int enableCloudwatchLogsExportsListIndex = 1;
                for (String enableCloudwatchLogsExportsListValue : enableCloudwatchLogsExportsList) {
                    if (enableCloudwatchLogsExportsListValue != null) {
                        request.addParameter("EnableCloudwatchLogsExports.member." + enableCloudwatchLogsExportsListIndex, StringUtils.fromString(enableCloudwatchLogsExportsListValue));
                    }
                    ++enableCloudwatchLogsExportsListIndex;
                }
            }
        }
        if (restoreDBClusterFromSnapshotRequest.getDeletionProtection() != null) {
            request.addParameter("DeletionProtection", StringUtils.fromBoolean(restoreDBClusterFromSnapshotRequest.getDeletionProtection()));
        }
        return request;
    }
}

