/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.docdb.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.docdb.model.DescribeDBClusterParameterGroupsRequest;
import com.amazonaws.services.docdb.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class DescribeDBClusterParameterGroupsRequestMarshaller
implements Marshaller<Request<DescribeDBClusterParameterGroupsRequest>, DescribeDBClusterParameterGroupsRequest> {
    @Override
    public Request<DescribeDBClusterParameterGroupsRequest> marshall(DescribeDBClusterParameterGroupsRequest describeDBClusterParameterGroupsRequest) {
        if (describeDBClusterParameterGroupsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeDBClusterParameterGroupsRequest> request = new DefaultRequest<DescribeDBClusterParameterGroupsRequest>(describeDBClusterParameterGroupsRequest, "AmazonDocDB");
        request.addParameter("Action", "DescribeDBClusterParameterGroups");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeDBClusterParameterGroupsRequest.getDBClusterParameterGroupName() != null) {
            request.addParameter("DBClusterParameterGroupName", StringUtils.fromString(describeDBClusterParameterGroupsRequest.getDBClusterParameterGroupName()));
        }
        if (describeDBClusterParameterGroupsRequest.getFilters() != null) {
            List<Filter> filtersList = describeDBClusterParameterGroupsRequest.getFilters();
            if (filtersList.isEmpty()) {
                request.addParameter("Filters", "");
            } else {
                int filtersListIndex = 1;
                for (Filter filtersListValue : filtersList) {
                    if (filtersListValue.getName() != null) {
                        request.addParameter("Filters.Filter." + filtersListIndex + ".Name", StringUtils.fromString(filtersListValue.getName()));
                    }
                    if (filtersListValue.getValues() != null) {
                        List<String> valuesList = filtersListValue.getValues();
                        if (valuesList.isEmpty()) {
                            request.addParameter("Filters.Filter." + filtersListIndex + ".Values", "");
                        } else {
                            int valuesListIndex = 1;
                            for (String valuesListValue : valuesList) {
                                if (valuesListValue != null) {
                                    request.addParameter("Filters.Filter." + filtersListIndex + ".Values.Value." + valuesListIndex, StringUtils.fromString(valuesListValue));
                                }
                                ++valuesListIndex;
                            }
                        }
                    }
                    ++filtersListIndex;
                }
            }
        }
        if (describeDBClusterParameterGroupsRequest.getMaxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger(describeDBClusterParameterGroupsRequest.getMaxRecords()));
        }
        if (describeDBClusterParameterGroupsRequest.getMarker() != null) {
            request.addParameter("Marker", StringUtils.fromString(describeDBClusterParameterGroupsRequest.getMarker()));
        }
        return request;
    }
}

