/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.docdb.model.transform;

import com.amazonaws.services.docdb.model.DBInstance;
import com.amazonaws.services.docdb.model.DBInstanceStatusInfo;
import com.amazonaws.services.docdb.model.VpcSecurityGroupMembership;
import com.amazonaws.services.docdb.model.transform.DBInstanceStatusInfoStaxUnmarshaller;
import com.amazonaws.services.docdb.model.transform.DBSubnetGroupStaxUnmarshaller;
import com.amazonaws.services.docdb.model.transform.EndpointStaxUnmarshaller;
import com.amazonaws.services.docdb.model.transform.PendingModifiedValuesStaxUnmarshaller;
import com.amazonaws.services.docdb.model.transform.VpcSecurityGroupMembershipStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class DBInstanceStaxUnmarshaller
implements Unmarshaller<DBInstance, StaxUnmarshallerContext> {
    private static DBInstanceStaxUnmarshaller instance;

    @Override
    public DBInstance unmarshall(StaxUnmarshallerContext context) throws Exception {
        DBInstance dBInstance = new DBInstance();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            targetDepth += 3;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return dBInstance;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("DBInstanceIdentifier", targetDepth)) {
                    dBInstance.setDBInstanceIdentifier(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DBInstanceClass", targetDepth)) {
                    dBInstance.setDBInstanceClass(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Engine", targetDepth)) {
                    dBInstance.setEngine(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DBInstanceStatus", targetDepth)) {
                    dBInstance.setDBInstanceStatus(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Endpoint", targetDepth)) {
                    dBInstance.setEndpoint(EndpointStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("InstanceCreateTime", targetDepth)) {
                    dBInstance.setInstanceCreateTime(SimpleTypeStaxUnmarshallers.DateStaxUnmarshallerFactory.getInstance("iso8601").unmarshall(context));
                    continue;
                }
                if (context.testExpression("PreferredBackupWindow", targetDepth)) {
                    dBInstance.setPreferredBackupWindow(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("BackupRetentionPeriod", targetDepth)) {
                    dBInstance.setBackupRetentionPeriod(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("VpcSecurityGroups", targetDepth)) {
                    dBInstance.withVpcSecurityGroups(new ArrayList<VpcSecurityGroupMembership>());
                    continue;
                }
                if (context.testExpression("VpcSecurityGroups/VpcSecurityGroupMembership", targetDepth)) {
                    dBInstance.withVpcSecurityGroups(VpcSecurityGroupMembershipStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("AvailabilityZone", targetDepth)) {
                    dBInstance.setAvailabilityZone(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DBSubnetGroup", targetDepth)) {
                    dBInstance.setDBSubnetGroup(DBSubnetGroupStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("PreferredMaintenanceWindow", targetDepth)) {
                    dBInstance.setPreferredMaintenanceWindow(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("PendingModifiedValues", targetDepth)) {
                    dBInstance.setPendingModifiedValues(PendingModifiedValuesStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("LatestRestorableTime", targetDepth)) {
                    dBInstance.setLatestRestorableTime(SimpleTypeStaxUnmarshallers.DateStaxUnmarshallerFactory.getInstance("iso8601").unmarshall(context));
                    continue;
                }
                if (context.testExpression("EngineVersion", targetDepth)) {
                    dBInstance.setEngineVersion(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("AutoMinorVersionUpgrade", targetDepth)) {
                    dBInstance.setAutoMinorVersionUpgrade(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("PubliclyAccessible", targetDepth)) {
                    dBInstance.setPubliclyAccessible(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("StatusInfos", targetDepth)) {
                    dBInstance.withStatusInfos(new ArrayList<DBInstanceStatusInfo>());
                    continue;
                }
                if (context.testExpression("StatusInfos/DBInstanceStatusInfo", targetDepth)) {
                    dBInstance.withStatusInfos(DBInstanceStatusInfoStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DBClusterIdentifier", targetDepth)) {
                    dBInstance.setDBClusterIdentifier(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("StorageEncrypted", targetDepth)) {
                    dBInstance.setStorageEncrypted(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("KmsKeyId", targetDepth)) {
                    dBInstance.setKmsKeyId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DbiResourceId", targetDepth)) {
                    dBInstance.setDbiResourceId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("PromotionTier", targetDepth)) {
                    dBInstance.setPromotionTier(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DBInstanceArn", targetDepth)) {
                    dBInstance.setDBInstanceArn(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("EnabledCloudwatchLogsExports", targetDepth)) {
                    dBInstance.withEnabledCloudwatchLogsExports(new ArrayList<String>());
                    continue;
                }
                if (!context.testExpression("EnabledCloudwatchLogsExports/member", targetDepth)) continue;
                dBInstance.withEnabledCloudwatchLogsExports(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return dBInstance;
    }

    public static DBInstanceStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new DBInstanceStaxUnmarshaller();
        }
        return instance;
    }
}

