/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dlm.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.dlm.model.Parameters;
import com.amazonaws.services.dlm.model.PolicyTypeValues;
import com.amazonaws.services.dlm.model.ResourceTypeValues;
import com.amazonaws.services.dlm.model.Schedule;
import com.amazonaws.services.dlm.model.Tag;
import com.amazonaws.services.dlm.model.transform.PolicyDetailsMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PolicyDetails
implements Serializable,
Cloneable,
StructuredPojo {
    private String policyType;
    private List<String> resourceTypes;
    private List<Tag> targetTags;
    private List<Schedule> schedules;
    private Parameters parameters;

    public void setPolicyType(String policyType) {
        this.policyType = policyType;
    }

    public String getPolicyType() {
        return this.policyType;
    }

    public PolicyDetails withPolicyType(String policyType) {
        this.setPolicyType(policyType);
        return this;
    }

    public PolicyDetails withPolicyType(PolicyTypeValues policyType) {
        this.policyType = policyType.toString();
        return this;
    }

    public List<String> getResourceTypes() {
        return this.resourceTypes;
    }

    public void setResourceTypes(Collection<String> resourceTypes) {
        if (resourceTypes == null) {
            this.resourceTypes = null;
            return;
        }
        this.resourceTypes = new ArrayList<String>(resourceTypes);
    }

    public PolicyDetails withResourceTypes(String ... resourceTypes) {
        if (this.resourceTypes == null) {
            this.setResourceTypes(new ArrayList<String>(resourceTypes.length));
        }
        for (String ele : resourceTypes) {
            this.resourceTypes.add(ele);
        }
        return this;
    }

    public PolicyDetails withResourceTypes(Collection<String> resourceTypes) {
        this.setResourceTypes(resourceTypes);
        return this;
    }

    public PolicyDetails withResourceTypes(ResourceTypeValues ... resourceTypes) {
        ArrayList<String> resourceTypesCopy = new ArrayList<String>(resourceTypes.length);
        for (ResourceTypeValues value : resourceTypes) {
            resourceTypesCopy.add(value.toString());
        }
        if (this.getResourceTypes() == null) {
            this.setResourceTypes(resourceTypesCopy);
        } else {
            this.getResourceTypes().addAll(resourceTypesCopy);
        }
        return this;
    }

    public List<Tag> getTargetTags() {
        return this.targetTags;
    }

    public void setTargetTags(Collection<Tag> targetTags) {
        if (targetTags == null) {
            this.targetTags = null;
            return;
        }
        this.targetTags = new ArrayList<Tag>(targetTags);
    }

    public PolicyDetails withTargetTags(Tag ... targetTags) {
        if (this.targetTags == null) {
            this.setTargetTags(new ArrayList<Tag>(targetTags.length));
        }
        for (Tag ele : targetTags) {
            this.targetTags.add(ele);
        }
        return this;
    }

    public PolicyDetails withTargetTags(Collection<Tag> targetTags) {
        this.setTargetTags(targetTags);
        return this;
    }

    public List<Schedule> getSchedules() {
        return this.schedules;
    }

    public void setSchedules(Collection<Schedule> schedules) {
        if (schedules == null) {
            this.schedules = null;
            return;
        }
        this.schedules = new ArrayList<Schedule>(schedules);
    }

    public PolicyDetails withSchedules(Schedule ... schedules) {
        if (this.schedules == null) {
            this.setSchedules(new ArrayList<Schedule>(schedules.length));
        }
        for (Schedule ele : schedules) {
            this.schedules.add(ele);
        }
        return this;
    }

    public PolicyDetails withSchedules(Collection<Schedule> schedules) {
        this.setSchedules(schedules);
        return this;
    }

    public void setParameters(Parameters parameters) {
        this.parameters = parameters;
    }

    public Parameters getParameters() {
        return this.parameters;
    }

    public PolicyDetails withParameters(Parameters parameters) {
        this.setParameters(parameters);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPolicyType() != null) {
            sb.append("PolicyType: ").append(this.getPolicyType()).append(",");
        }
        if (this.getResourceTypes() != null) {
            sb.append("ResourceTypes: ").append(this.getResourceTypes()).append(",");
        }
        if (this.getTargetTags() != null) {
            sb.append("TargetTags: ").append(this.getTargetTags()).append(",");
        }
        if (this.getSchedules() != null) {
            sb.append("Schedules: ").append(this.getSchedules()).append(",");
        }
        if (this.getParameters() != null) {
            sb.append("Parameters: ").append(this.getParameters());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PolicyDetails)) {
            return false;
        }
        PolicyDetails other = (PolicyDetails)obj;
        if (other.getPolicyType() == null ^ this.getPolicyType() == null) {
            return false;
        }
        if (other.getPolicyType() != null && !other.getPolicyType().equals(this.getPolicyType())) {
            return false;
        }
        if (other.getResourceTypes() == null ^ this.getResourceTypes() == null) {
            return false;
        }
        if (other.getResourceTypes() != null && !other.getResourceTypes().equals(this.getResourceTypes())) {
            return false;
        }
        if (other.getTargetTags() == null ^ this.getTargetTags() == null) {
            return false;
        }
        if (other.getTargetTags() != null && !other.getTargetTags().equals(this.getTargetTags())) {
            return false;
        }
        if (other.getSchedules() == null ^ this.getSchedules() == null) {
            return false;
        }
        if (other.getSchedules() != null && !other.getSchedules().equals(this.getSchedules())) {
            return false;
        }
        if (other.getParameters() == null ^ this.getParameters() == null) {
            return false;
        }
        return other.getParameters() == null || other.getParameters().equals(this.getParameters());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPolicyType() == null ? 0 : this.getPolicyType().hashCode());
        hashCode = 31 * hashCode + (this.getResourceTypes() == null ? 0 : this.getResourceTypes().hashCode());
        hashCode = 31 * hashCode + (this.getTargetTags() == null ? 0 : this.getTargetTags().hashCode());
        hashCode = 31 * hashCode + (this.getSchedules() == null ? 0 : this.getSchedules().hashCode());
        hashCode = 31 * hashCode + (this.getParameters() == null ? 0 : this.getParameters().hashCode());
        return hashCode;
    }

    public PolicyDetails clone() {
        try {
            return (PolicyDetails)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PolicyDetailsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

