/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datasync.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.datasync.model.TagListEntry;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateAgentRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String activationKey;
    private String agentName;
    private List<TagListEntry> tags;

    public void setActivationKey(String activationKey) {
        this.activationKey = activationKey;
    }

    public String getActivationKey() {
        return this.activationKey;
    }

    public CreateAgentRequest withActivationKey(String activationKey) {
        this.setActivationKey(activationKey);
        return this;
    }

    public void setAgentName(String agentName) {
        this.agentName = agentName;
    }

    public String getAgentName() {
        return this.agentName;
    }

    public CreateAgentRequest withAgentName(String agentName) {
        this.setAgentName(agentName);
        return this;
    }

    public List<TagListEntry> getTags() {
        return this.tags;
    }

    public void setTags(Collection<TagListEntry> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<TagListEntry>(tags);
    }

    public CreateAgentRequest withTags(TagListEntry ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<TagListEntry>(tags.length));
        }
        for (TagListEntry ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateAgentRequest withTags(Collection<TagListEntry> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getActivationKey() != null) {
            sb.append("ActivationKey: ").append(this.getActivationKey()).append(",");
        }
        if (this.getAgentName() != null) {
            sb.append("AgentName: ").append(this.getAgentName()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAgentRequest)) {
            return false;
        }
        CreateAgentRequest other = (CreateAgentRequest)obj;
        if (other.getActivationKey() == null ^ this.getActivationKey() == null) {
            return false;
        }
        if (other.getActivationKey() != null && !other.getActivationKey().equals(this.getActivationKey())) {
            return false;
        }
        if (other.getAgentName() == null ^ this.getAgentName() == null) {
            return false;
        }
        if (other.getAgentName() != null && !other.getAgentName().equals(this.getAgentName())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getActivationKey() == null ? 0 : this.getActivationKey().hashCode());
        hashCode = 31 * hashCode + (this.getAgentName() == null ? 0 : this.getAgentName().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    @Override
    public CreateAgentRequest clone() {
        return (CreateAgentRequest)super.clone();
    }
}

