/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datasync;

import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.datasync.AWSDataSyncAsync;
import com.amazonaws.services.datasync.AWSDataSyncAsyncClientBuilder;
import com.amazonaws.services.datasync.AWSDataSyncClient;
import com.amazonaws.services.datasync.model.CancelTaskExecutionRequest;
import com.amazonaws.services.datasync.model.CancelTaskExecutionResult;
import com.amazonaws.services.datasync.model.CreateAgentRequest;
import com.amazonaws.services.datasync.model.CreateAgentResult;
import com.amazonaws.services.datasync.model.CreateLocationEfsRequest;
import com.amazonaws.services.datasync.model.CreateLocationEfsResult;
import com.amazonaws.services.datasync.model.CreateLocationNfsRequest;
import com.amazonaws.services.datasync.model.CreateLocationNfsResult;
import com.amazonaws.services.datasync.model.CreateLocationS3Request;
import com.amazonaws.services.datasync.model.CreateLocationS3Result;
import com.amazonaws.services.datasync.model.CreateTaskRequest;
import com.amazonaws.services.datasync.model.CreateTaskResult;
import com.amazonaws.services.datasync.model.DeleteAgentRequest;
import com.amazonaws.services.datasync.model.DeleteAgentResult;
import com.amazonaws.services.datasync.model.DeleteLocationRequest;
import com.amazonaws.services.datasync.model.DeleteLocationResult;
import com.amazonaws.services.datasync.model.DeleteTaskRequest;
import com.amazonaws.services.datasync.model.DeleteTaskResult;
import com.amazonaws.services.datasync.model.DescribeAgentRequest;
import com.amazonaws.services.datasync.model.DescribeAgentResult;
import com.amazonaws.services.datasync.model.DescribeLocationEfsRequest;
import com.amazonaws.services.datasync.model.DescribeLocationEfsResult;
import com.amazonaws.services.datasync.model.DescribeLocationNfsRequest;
import com.amazonaws.services.datasync.model.DescribeLocationNfsResult;
import com.amazonaws.services.datasync.model.DescribeLocationS3Request;
import com.amazonaws.services.datasync.model.DescribeLocationS3Result;
import com.amazonaws.services.datasync.model.DescribeTaskExecutionRequest;
import com.amazonaws.services.datasync.model.DescribeTaskExecutionResult;
import com.amazonaws.services.datasync.model.DescribeTaskRequest;
import com.amazonaws.services.datasync.model.DescribeTaskResult;
import com.amazonaws.services.datasync.model.ListAgentsRequest;
import com.amazonaws.services.datasync.model.ListAgentsResult;
import com.amazonaws.services.datasync.model.ListLocationsRequest;
import com.amazonaws.services.datasync.model.ListLocationsResult;
import com.amazonaws.services.datasync.model.ListTagsForResourceRequest;
import com.amazonaws.services.datasync.model.ListTagsForResourceResult;
import com.amazonaws.services.datasync.model.ListTaskExecutionsRequest;
import com.amazonaws.services.datasync.model.ListTaskExecutionsResult;
import com.amazonaws.services.datasync.model.ListTasksRequest;
import com.amazonaws.services.datasync.model.ListTasksResult;
import com.amazonaws.services.datasync.model.StartTaskExecutionRequest;
import com.amazonaws.services.datasync.model.StartTaskExecutionResult;
import com.amazonaws.services.datasync.model.TagResourceRequest;
import com.amazonaws.services.datasync.model.TagResourceResult;
import com.amazonaws.services.datasync.model.UntagResourceRequest;
import com.amazonaws.services.datasync.model.UntagResourceResult;
import com.amazonaws.services.datasync.model.UpdateAgentRequest;
import com.amazonaws.services.datasync.model.UpdateAgentResult;
import com.amazonaws.services.datasync.model.UpdateTaskRequest;
import com.amazonaws.services.datasync.model.UpdateTaskResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSDataSyncAsyncClient
extends AWSDataSyncClient
implements AWSDataSyncAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSDataSyncAsyncClientBuilder asyncBuilder() {
        return AWSDataSyncAsyncClientBuilder.standard();
    }

    AWSDataSyncAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super(asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CancelTaskExecutionResult> cancelTaskExecutionAsync(CancelTaskExecutionRequest request) {
        return this.cancelTaskExecutionAsync(request, null);
    }

    @Override
    public Future<CancelTaskExecutionResult> cancelTaskExecutionAsync(CancelTaskExecutionRequest request, final AsyncHandler<CancelTaskExecutionRequest, CancelTaskExecutionResult> asyncHandler) {
        final CancelTaskExecutionRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CancelTaskExecutionResult>(){

            @Override
            public CancelTaskExecutionResult call() throws Exception {
                CancelTaskExecutionResult result = null;
                try {
                    result = AWSDataSyncAsyncClient.this.executeCancelTaskExecution(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateAgentResult> createAgentAsync(CreateAgentRequest request) {
        return this.createAgentAsync(request, null);
    }

    @Override
    public Future<CreateAgentResult> createAgentAsync(CreateAgentRequest request, final AsyncHandler<CreateAgentRequest, CreateAgentResult> asyncHandler) {
        final CreateAgentRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateAgentResult>(){

            @Override
            public CreateAgentResult call() throws Exception {
                CreateAgentResult result = null;
                try {
                    result = AWSDataSyncAsyncClient.this.executeCreateAgent(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateLocationEfsResult> createLocationEfsAsync(CreateLocationEfsRequest request) {
        return this.createLocationEfsAsync(request, null);
    }

    @Override
    public Future<CreateLocationEfsResult> createLocationEfsAsync(CreateLocationEfsRequest request, final AsyncHandler<CreateLocationEfsRequest, CreateLocationEfsResult> asyncHandler) {
        final CreateLocationEfsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateLocationEfsResult>(){

            @Override
            public CreateLocationEfsResult call() throws Exception {
                CreateLocationEfsResult result = null;
                try {
                    result = AWSDataSyncAsyncClient.this.executeCreateLocationEfs(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateLocationNfsResult> createLocationNfsAsync(CreateLocationNfsRequest request) {
        return this.createLocationNfsAsync(request, null);
    }

    @Override
    public Future<CreateLocationNfsResult> createLocationNfsAsync(CreateLocationNfsRequest request, final AsyncHandler<CreateLocationNfsRequest, CreateLocationNfsResult> asyncHandler) {
        final CreateLocationNfsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateLocationNfsResult>(){

            @Override
            public CreateLocationNfsResult call() throws Exception {
                CreateLocationNfsResult result = null;
                try {
                    result = AWSDataSyncAsyncClient.this.executeCreateLocationNfs(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateLocationS3Result> createLocationS3Async(CreateLocationS3Request request) {
        return this.createLocationS3Async(request, null);
    }

    @Override
    public Future<CreateLocationS3Result> createLocationS3Async(CreateLocationS3Request request, final AsyncHandler<CreateLocationS3Request, CreateLocationS3Result> asyncHandler) {
        final CreateLocationS3Request finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateLocationS3Result>(){

            @Override
            public CreateLocationS3Result call() throws Exception {
                CreateLocationS3Result result = null;
                try {
                    result = AWSDataSyncAsyncClient.this.executeCreateLocationS3(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateTaskResult> createTaskAsync(CreateTaskRequest request) {
        return this.createTaskAsync(request, null);
    }

    @Override
    public Future<CreateTaskResult> createTaskAsync(CreateTaskRequest request, final AsyncHandler<CreateTaskRequest, CreateTaskResult> asyncHandler) {
        final CreateTaskRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateTaskResult>(){

            @Override
            public CreateTaskResult call() throws Exception {
                CreateTaskResult result = null;
                try {
                    result = AWSDataSyncAsyncClient.this.executeCreateTask(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteAgentResult> deleteAgentAsync(DeleteAgentRequest request) {
        return this.deleteAgentAsync(request, null);
    }

    @Override
    public Future<DeleteAgentResult> deleteAgentAsync(DeleteAgentRequest request, final AsyncHandler<DeleteAgentRequest, DeleteAgentResult> asyncHandler) {
        final DeleteAgentRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteAgentResult>(){

            @Override
            public DeleteAgentResult call() throws Exception {
                DeleteAgentResult result = null;
                try {
                    result = AWSDataSyncAsyncClient.this.executeDeleteAgent(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteLocationResult> deleteLocationAsync(DeleteLocationRequest request) {
        return this.deleteLocationAsync(request, null);
    }

    @Override
    public Future<DeleteLocationResult> deleteLocationAsync(DeleteLocationRequest request, final AsyncHandler<DeleteLocationRequest, DeleteLocationResult> asyncHandler) {
        final DeleteLocationRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteLocationResult>(){

            @Override
            public DeleteLocationResult call() throws Exception {
                DeleteLocationResult result = null;
                try {
                    result = AWSDataSyncAsyncClient.this.executeDeleteLocation(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteTaskResult> deleteTaskAsync(DeleteTaskRequest request) {
        return this.deleteTaskAsync(request, null);
    }

    @Override
    public Future<DeleteTaskResult> deleteTaskAsync(DeleteTaskRequest request, final AsyncHandler<DeleteTaskRequest, DeleteTaskResult> asyncHandler) {
        final DeleteTaskRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteTaskResult>(){

            @Override
            public DeleteTaskResult call() throws Exception {
                DeleteTaskResult result = null;
                try {
                    result = AWSDataSyncAsyncClient.this.executeDeleteTask(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeAgentResult> describeAgentAsync(DescribeAgentRequest request) {
        return this.describeAgentAsync(request, null);
    }

    @Override
    public Future<DescribeAgentResult> describeAgentAsync(DescribeAgentRequest request, final AsyncHandler<DescribeAgentRequest, DescribeAgentResult> asyncHandler) {
        final DescribeAgentRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeAgentResult>(){

            @Override
            public DescribeAgentResult call() throws Exception {
                DescribeAgentResult result = null;
                try {
                    result = AWSDataSyncAsyncClient.this.executeDescribeAgent(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeLocationEfsResult> describeLocationEfsAsync(DescribeLocationEfsRequest request) {
        return this.describeLocationEfsAsync(request, null);
    }

    @Override
    public Future<DescribeLocationEfsResult> describeLocationEfsAsync(DescribeLocationEfsRequest request, final AsyncHandler<DescribeLocationEfsRequest, DescribeLocationEfsResult> asyncHandler) {
        final DescribeLocationEfsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeLocationEfsResult>(){

            @Override
            public DescribeLocationEfsResult call() throws Exception {
                DescribeLocationEfsResult result = null;
                try {
                    result = AWSDataSyncAsyncClient.this.executeDescribeLocationEfs(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeLocationNfsResult> describeLocationNfsAsync(DescribeLocationNfsRequest request) {
        return this.describeLocationNfsAsync(request, null);
    }

    @Override
    public Future<DescribeLocationNfsResult> describeLocationNfsAsync(DescribeLocationNfsRequest request, final AsyncHandler<DescribeLocationNfsRequest, DescribeLocationNfsResult> asyncHandler) {
        final DescribeLocationNfsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeLocationNfsResult>(){

            @Override
            public DescribeLocationNfsResult call() throws Exception {
                DescribeLocationNfsResult result = null;
                try {
                    result = AWSDataSyncAsyncClient.this.executeDescribeLocationNfs(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeLocationS3Result> describeLocationS3Async(DescribeLocationS3Request request) {
        return this.describeLocationS3Async(request, null);
    }

    @Override
    public Future<DescribeLocationS3Result> describeLocationS3Async(DescribeLocationS3Request request, final AsyncHandler<DescribeLocationS3Request, DescribeLocationS3Result> asyncHandler) {
        final DescribeLocationS3Request finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeLocationS3Result>(){

            @Override
            public DescribeLocationS3Result call() throws Exception {
                DescribeLocationS3Result result = null;
                try {
                    result = AWSDataSyncAsyncClient.this.executeDescribeLocationS3(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeTaskResult> describeTaskAsync(DescribeTaskRequest request) {
        return this.describeTaskAsync(request, null);
    }

    @Override
    public Future<DescribeTaskResult> describeTaskAsync(DescribeTaskRequest request, final AsyncHandler<DescribeTaskRequest, DescribeTaskResult> asyncHandler) {
        final DescribeTaskRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeTaskResult>(){

            @Override
            public DescribeTaskResult call() throws Exception {
                DescribeTaskResult result = null;
                try {
                    result = AWSDataSyncAsyncClient.this.executeDescribeTask(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeTaskExecutionResult> describeTaskExecutionAsync(DescribeTaskExecutionRequest request) {
        return this.describeTaskExecutionAsync(request, null);
    }

    @Override
    public Future<DescribeTaskExecutionResult> describeTaskExecutionAsync(DescribeTaskExecutionRequest request, final AsyncHandler<DescribeTaskExecutionRequest, DescribeTaskExecutionResult> asyncHandler) {
        final DescribeTaskExecutionRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeTaskExecutionResult>(){

            @Override
            public DescribeTaskExecutionResult call() throws Exception {
                DescribeTaskExecutionResult result = null;
                try {
                    result = AWSDataSyncAsyncClient.this.executeDescribeTaskExecution(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListAgentsResult> listAgentsAsync(ListAgentsRequest request) {
        return this.listAgentsAsync(request, null);
    }

    @Override
    public Future<ListAgentsResult> listAgentsAsync(ListAgentsRequest request, final AsyncHandler<ListAgentsRequest, ListAgentsResult> asyncHandler) {
        final ListAgentsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListAgentsResult>(){

            @Override
            public ListAgentsResult call() throws Exception {
                ListAgentsResult result = null;
                try {
                    result = AWSDataSyncAsyncClient.this.executeListAgents(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListLocationsResult> listLocationsAsync(ListLocationsRequest request) {
        return this.listLocationsAsync(request, null);
    }

    @Override
    public Future<ListLocationsResult> listLocationsAsync(ListLocationsRequest request, final AsyncHandler<ListLocationsRequest, ListLocationsResult> asyncHandler) {
        final ListLocationsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListLocationsResult>(){

            @Override
            public ListLocationsResult call() throws Exception {
                ListLocationsResult result = null;
                try {
                    result = AWSDataSyncAsyncClient.this.executeListLocations(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AWSDataSyncAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTaskExecutionsResult> listTaskExecutionsAsync(ListTaskExecutionsRequest request) {
        return this.listTaskExecutionsAsync(request, null);
    }

    @Override
    public Future<ListTaskExecutionsResult> listTaskExecutionsAsync(ListTaskExecutionsRequest request, final AsyncHandler<ListTaskExecutionsRequest, ListTaskExecutionsResult> asyncHandler) {
        final ListTaskExecutionsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTaskExecutionsResult>(){

            @Override
            public ListTaskExecutionsResult call() throws Exception {
                ListTaskExecutionsResult result = null;
                try {
                    result = AWSDataSyncAsyncClient.this.executeListTaskExecutions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTasksResult> listTasksAsync(ListTasksRequest request) {
        return this.listTasksAsync(request, null);
    }

    @Override
    public Future<ListTasksResult> listTasksAsync(ListTasksRequest request, final AsyncHandler<ListTasksRequest, ListTasksResult> asyncHandler) {
        final ListTasksRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTasksResult>(){

            @Override
            public ListTasksResult call() throws Exception {
                ListTasksResult result = null;
                try {
                    result = AWSDataSyncAsyncClient.this.executeListTasks(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartTaskExecutionResult> startTaskExecutionAsync(StartTaskExecutionRequest request) {
        return this.startTaskExecutionAsync(request, null);
    }

    @Override
    public Future<StartTaskExecutionResult> startTaskExecutionAsync(StartTaskExecutionRequest request, final AsyncHandler<StartTaskExecutionRequest, StartTaskExecutionResult> asyncHandler) {
        final StartTaskExecutionRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartTaskExecutionResult>(){

            @Override
            public StartTaskExecutionResult call() throws Exception {
                StartTaskExecutionResult result = null;
                try {
                    result = AWSDataSyncAsyncClient.this.executeStartTaskExecution(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AWSDataSyncAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AWSDataSyncAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateAgentResult> updateAgentAsync(UpdateAgentRequest request) {
        return this.updateAgentAsync(request, null);
    }

    @Override
    public Future<UpdateAgentResult> updateAgentAsync(UpdateAgentRequest request, final AsyncHandler<UpdateAgentRequest, UpdateAgentResult> asyncHandler) {
        final UpdateAgentRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateAgentResult>(){

            @Override
            public UpdateAgentResult call() throws Exception {
                UpdateAgentResult result = null;
                try {
                    result = AWSDataSyncAsyncClient.this.executeUpdateAgent(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateTaskResult> updateTaskAsync(UpdateTaskRequest request) {
        return this.updateTaskAsync(request, null);
    }

    @Override
    public Future<UpdateTaskResult> updateTaskAsync(UpdateTaskRequest request, final AsyncHandler<UpdateTaskRequest, UpdateTaskResult> asyncHandler) {
        final UpdateTaskRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateTaskResult>(){

            @Override
            public UpdateTaskResult call() throws Exception {
                UpdateTaskResult result = null;
                try {
                    result = AWSDataSyncAsyncClient.this.executeUpdateTask(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

