/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.connect.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.connect.model.Credentials;
import java.util.Date;

@SdkInternalApi
public class CredentialsMarshaller {
    private static final MarshallingInfo<String> ACCESSTOKEN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AccessToken").build();
    private static final MarshallingInfo<Date> ACCESSTOKENEXPIRATION_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AccessTokenExpiration").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> REFRESHTOKEN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RefreshToken").build();
    private static final MarshallingInfo<Date> REFRESHTOKENEXPIRATION_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RefreshTokenExpiration").timestampFormat("unixTimestamp").build();
    private static final CredentialsMarshaller instance = new CredentialsMarshaller();

    public static CredentialsMarshaller getInstance() {
        return instance;
    }

    public void marshall(Credentials credentials, ProtocolMarshaller protocolMarshaller) {
        if (credentials == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(credentials.getAccessToken(), ACCESSTOKEN_BINDING);
            protocolMarshaller.marshall(credentials.getAccessTokenExpiration(), ACCESSTOKENEXPIRATION_BINDING);
            protocolMarshaller.marshall(credentials.getRefreshToken(), REFRESHTOKEN_BINDING);
            protocolMarshaller.marshall(credentials.getRefreshTokenExpiration(), REFRESHTOKENEXPIRATION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

