/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.comprehend.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.comprehend.model.EntityRecognizerAnnotations;
import com.amazonaws.services.comprehend.model.EntityRecognizerDocuments;
import com.amazonaws.services.comprehend.model.EntityRecognizerEntityList;
import com.amazonaws.services.comprehend.model.EntityTypesListItem;
import com.amazonaws.services.comprehend.model.transform.EntityRecognizerInputDataConfigMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class EntityRecognizerInputDataConfig
implements Serializable,
Cloneable,
StructuredPojo {
    private List<EntityTypesListItem> entityTypes;
    private EntityRecognizerDocuments documents;
    private EntityRecognizerAnnotations annotations;
    private EntityRecognizerEntityList entityList;

    public List<EntityTypesListItem> getEntityTypes() {
        return this.entityTypes;
    }

    public void setEntityTypes(Collection<EntityTypesListItem> entityTypes) {
        if (entityTypes == null) {
            this.entityTypes = null;
            return;
        }
        this.entityTypes = new ArrayList<EntityTypesListItem>(entityTypes);
    }

    public EntityRecognizerInputDataConfig withEntityTypes(EntityTypesListItem ... entityTypes) {
        if (this.entityTypes == null) {
            this.setEntityTypes(new ArrayList<EntityTypesListItem>(entityTypes.length));
        }
        for (EntityTypesListItem ele : entityTypes) {
            this.entityTypes.add(ele);
        }
        return this;
    }

    public EntityRecognizerInputDataConfig withEntityTypes(Collection<EntityTypesListItem> entityTypes) {
        this.setEntityTypes(entityTypes);
        return this;
    }

    public void setDocuments(EntityRecognizerDocuments documents) {
        this.documents = documents;
    }

    public EntityRecognizerDocuments getDocuments() {
        return this.documents;
    }

    public EntityRecognizerInputDataConfig withDocuments(EntityRecognizerDocuments documents) {
        this.setDocuments(documents);
        return this;
    }

    public void setAnnotations(EntityRecognizerAnnotations annotations) {
        this.annotations = annotations;
    }

    public EntityRecognizerAnnotations getAnnotations() {
        return this.annotations;
    }

    public EntityRecognizerInputDataConfig withAnnotations(EntityRecognizerAnnotations annotations) {
        this.setAnnotations(annotations);
        return this;
    }

    public void setEntityList(EntityRecognizerEntityList entityList) {
        this.entityList = entityList;
    }

    public EntityRecognizerEntityList getEntityList() {
        return this.entityList;
    }

    public EntityRecognizerInputDataConfig withEntityList(EntityRecognizerEntityList entityList) {
        this.setEntityList(entityList);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEntityTypes() != null) {
            sb.append("EntityTypes: ").append(this.getEntityTypes()).append(",");
        }
        if (this.getDocuments() != null) {
            sb.append("Documents: ").append(this.getDocuments()).append(",");
        }
        if (this.getAnnotations() != null) {
            sb.append("Annotations: ").append(this.getAnnotations()).append(",");
        }
        if (this.getEntityList() != null) {
            sb.append("EntityList: ").append(this.getEntityList());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EntityRecognizerInputDataConfig)) {
            return false;
        }
        EntityRecognizerInputDataConfig other = (EntityRecognizerInputDataConfig)obj;
        if (other.getEntityTypes() == null ^ this.getEntityTypes() == null) {
            return false;
        }
        if (other.getEntityTypes() != null && !other.getEntityTypes().equals(this.getEntityTypes())) {
            return false;
        }
        if (other.getDocuments() == null ^ this.getDocuments() == null) {
            return false;
        }
        if (other.getDocuments() != null && !other.getDocuments().equals(this.getDocuments())) {
            return false;
        }
        if (other.getAnnotations() == null ^ this.getAnnotations() == null) {
            return false;
        }
        if (other.getAnnotations() != null && !other.getAnnotations().equals(this.getAnnotations())) {
            return false;
        }
        if (other.getEntityList() == null ^ this.getEntityList() == null) {
            return false;
        }
        return other.getEntityList() == null || other.getEntityList().equals(this.getEntityList());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEntityTypes() == null ? 0 : this.getEntityTypes().hashCode());
        hashCode = 31 * hashCode + (this.getDocuments() == null ? 0 : this.getDocuments().hashCode());
        hashCode = 31 * hashCode + (this.getAnnotations() == null ? 0 : this.getAnnotations().hashCode());
        hashCode = 31 * hashCode + (this.getEntityList() == null ? 0 : this.getEntityList().hashCode());
        return hashCode;
    }

    public EntityRecognizerInputDataConfig clone() {
        try {
            return (EntityRecognizerInputDataConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EntityRecognizerInputDataConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

