/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.comprehend.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.comprehend.model.ClassifierEvaluationMetrics;
import com.amazonaws.services.comprehend.model.transform.ClassifierMetadataMarshaller;
import java.io.Serializable;

public class ClassifierMetadata
implements Serializable,
Cloneable,
StructuredPojo {
    private Integer numberOfLabels;
    private Integer numberOfTrainedDocuments;
    private Integer numberOfTestDocuments;
    private ClassifierEvaluationMetrics evaluationMetrics;

    public void setNumberOfLabels(Integer numberOfLabels) {
        this.numberOfLabels = numberOfLabels;
    }

    public Integer getNumberOfLabels() {
        return this.numberOfLabels;
    }

    public ClassifierMetadata withNumberOfLabels(Integer numberOfLabels) {
        this.setNumberOfLabels(numberOfLabels);
        return this;
    }

    public void setNumberOfTrainedDocuments(Integer numberOfTrainedDocuments) {
        this.numberOfTrainedDocuments = numberOfTrainedDocuments;
    }

    public Integer getNumberOfTrainedDocuments() {
        return this.numberOfTrainedDocuments;
    }

    public ClassifierMetadata withNumberOfTrainedDocuments(Integer numberOfTrainedDocuments) {
        this.setNumberOfTrainedDocuments(numberOfTrainedDocuments);
        return this;
    }

    public void setNumberOfTestDocuments(Integer numberOfTestDocuments) {
        this.numberOfTestDocuments = numberOfTestDocuments;
    }

    public Integer getNumberOfTestDocuments() {
        return this.numberOfTestDocuments;
    }

    public ClassifierMetadata withNumberOfTestDocuments(Integer numberOfTestDocuments) {
        this.setNumberOfTestDocuments(numberOfTestDocuments);
        return this;
    }

    public void setEvaluationMetrics(ClassifierEvaluationMetrics evaluationMetrics) {
        this.evaluationMetrics = evaluationMetrics;
    }

    public ClassifierEvaluationMetrics getEvaluationMetrics() {
        return this.evaluationMetrics;
    }

    public ClassifierMetadata withEvaluationMetrics(ClassifierEvaluationMetrics evaluationMetrics) {
        this.setEvaluationMetrics(evaluationMetrics);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNumberOfLabels() != null) {
            sb.append("NumberOfLabels: ").append(this.getNumberOfLabels()).append(",");
        }
        if (this.getNumberOfTrainedDocuments() != null) {
            sb.append("NumberOfTrainedDocuments: ").append(this.getNumberOfTrainedDocuments()).append(",");
        }
        if (this.getNumberOfTestDocuments() != null) {
            sb.append("NumberOfTestDocuments: ").append(this.getNumberOfTestDocuments()).append(",");
        }
        if (this.getEvaluationMetrics() != null) {
            sb.append("EvaluationMetrics: ").append(this.getEvaluationMetrics());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClassifierMetadata)) {
            return false;
        }
        ClassifierMetadata other = (ClassifierMetadata)obj;
        if (other.getNumberOfLabels() == null ^ this.getNumberOfLabels() == null) {
            return false;
        }
        if (other.getNumberOfLabels() != null && !other.getNumberOfLabels().equals(this.getNumberOfLabels())) {
            return false;
        }
        if (other.getNumberOfTrainedDocuments() == null ^ this.getNumberOfTrainedDocuments() == null) {
            return false;
        }
        if (other.getNumberOfTrainedDocuments() != null && !other.getNumberOfTrainedDocuments().equals(this.getNumberOfTrainedDocuments())) {
            return false;
        }
        if (other.getNumberOfTestDocuments() == null ^ this.getNumberOfTestDocuments() == null) {
            return false;
        }
        if (other.getNumberOfTestDocuments() != null && !other.getNumberOfTestDocuments().equals(this.getNumberOfTestDocuments())) {
            return false;
        }
        if (other.getEvaluationMetrics() == null ^ this.getEvaluationMetrics() == null) {
            return false;
        }
        return other.getEvaluationMetrics() == null || other.getEvaluationMetrics().equals(this.getEvaluationMetrics());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNumberOfLabels() == null ? 0 : this.getNumberOfLabels().hashCode());
        hashCode = 31 * hashCode + (this.getNumberOfTrainedDocuments() == null ? 0 : this.getNumberOfTrainedDocuments().hashCode());
        hashCode = 31 * hashCode + (this.getNumberOfTestDocuments() == null ? 0 : this.getNumberOfTestDocuments().hashCode());
        hashCode = 31 * hashCode + (this.getEvaluationMetrics() == null ? 0 : this.getEvaluationMetrics().hashCode());
        return hashCode;
    }

    public ClassifierMetadata clone() {
        try {
            return (ClassifierMetadata)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ClassifierMetadataMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

