/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.comprehend.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.comprehend.model.SyntaxToken;
import com.amazonaws.services.comprehend.model.transform.BatchDetectSyntaxItemResultMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BatchDetectSyntaxItemResult
implements Serializable,
Cloneable,
StructuredPojo {
    private Integer index;
    private List<SyntaxToken> syntaxTokens;

    public void setIndex(Integer index) {
        this.index = index;
    }

    public Integer getIndex() {
        return this.index;
    }

    public BatchDetectSyntaxItemResult withIndex(Integer index) {
        this.setIndex(index);
        return this;
    }

    public List<SyntaxToken> getSyntaxTokens() {
        return this.syntaxTokens;
    }

    public void setSyntaxTokens(Collection<SyntaxToken> syntaxTokens) {
        if (syntaxTokens == null) {
            this.syntaxTokens = null;
            return;
        }
        this.syntaxTokens = new ArrayList<SyntaxToken>(syntaxTokens);
    }

    public BatchDetectSyntaxItemResult withSyntaxTokens(SyntaxToken ... syntaxTokens) {
        if (this.syntaxTokens == null) {
            this.setSyntaxTokens(new ArrayList<SyntaxToken>(syntaxTokens.length));
        }
        for (SyntaxToken ele : syntaxTokens) {
            this.syntaxTokens.add(ele);
        }
        return this;
    }

    public BatchDetectSyntaxItemResult withSyntaxTokens(Collection<SyntaxToken> syntaxTokens) {
        this.setSyntaxTokens(syntaxTokens);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getIndex() != null) {
            sb.append("Index: ").append(this.getIndex()).append(",");
        }
        if (this.getSyntaxTokens() != null) {
            sb.append("SyntaxTokens: ").append(this.getSyntaxTokens());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDetectSyntaxItemResult)) {
            return false;
        }
        BatchDetectSyntaxItemResult other = (BatchDetectSyntaxItemResult)obj;
        if (other.getIndex() == null ^ this.getIndex() == null) {
            return false;
        }
        if (other.getIndex() != null && !other.getIndex().equals(this.getIndex())) {
            return false;
        }
        if (other.getSyntaxTokens() == null ^ this.getSyntaxTokens() == null) {
            return false;
        }
        return other.getSyntaxTokens() == null || other.getSyntaxTokens().equals(this.getSyntaxTokens());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getIndex() == null ? 0 : this.getIndex().hashCode());
        hashCode = 31 * hashCode + (this.getSyntaxTokens() == null ? 0 : this.getSyntaxTokens().hashCode());
        return hashCode;
    }

    public BatchDetectSyntaxItemResult clone() {
        try {
            return (BatchDetectSyntaxItemResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BatchDetectSyntaxItemResultMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

