/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chime.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.chime.model.User;
import java.util.Date;

@SdkInternalApi
public class UserMarshaller {
    private static final MarshallingInfo<String> USERID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UserId").build();
    private static final MarshallingInfo<String> ACCOUNTID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AccountId").build();
    private static final MarshallingInfo<String> PRIMARYEMAIL_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PrimaryEmail").build();
    private static final MarshallingInfo<String> PRIMARYPROVISIONEDNUMBER_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PrimaryProvisionedNumber").build();
    private static final MarshallingInfo<String> DISPLAYNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DisplayName").build();
    private static final MarshallingInfo<String> LICENSETYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LicenseType").build();
    private static final MarshallingInfo<String> USERREGISTRATIONSTATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UserRegistrationStatus").build();
    private static final MarshallingInfo<String> USERINVITATIONSTATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UserInvitationStatus").build();
    private static final MarshallingInfo<Date> REGISTEREDON_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RegisteredOn").timestampFormat("iso8601").build();
    private static final MarshallingInfo<Date> INVITEDON_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InvitedOn").timestampFormat("iso8601").build();
    private static final MarshallingInfo<String> PERSONALPIN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PersonalPIN").build();
    private static final UserMarshaller instance = new UserMarshaller();

    public static UserMarshaller getInstance() {
        return instance;
    }

    public void marshall(User user, ProtocolMarshaller protocolMarshaller) {
        if (user == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(user.getUserId(), USERID_BINDING);
            protocolMarshaller.marshall(user.getAccountId(), ACCOUNTID_BINDING);
            protocolMarshaller.marshall(user.getPrimaryEmail(), PRIMARYEMAIL_BINDING);
            protocolMarshaller.marshall(user.getPrimaryProvisionedNumber(), PRIMARYPROVISIONEDNUMBER_BINDING);
            protocolMarshaller.marshall(user.getDisplayName(), DISPLAYNAME_BINDING);
            protocolMarshaller.marshall(user.getLicenseType(), LICENSETYPE_BINDING);
            protocolMarshaller.marshall(user.getUserRegistrationStatus(), USERREGISTRATIONSTATUS_BINDING);
            protocolMarshaller.marshall(user.getUserInvitationStatus(), USERINVITATIONSTATUS_BINDING);
            protocolMarshaller.marshall(user.getRegisteredOn(), REGISTEREDON_BINDING);
            protocolMarshaller.marshall(user.getInvitedOn(), INVITEDON_BINDING);
            protocolMarshaller.marshall(user.getPersonalPIN(), PERSONALPIN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

