/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chime.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.chime.model.UserError;

@SdkInternalApi
public class UserErrorMarshaller {
    private static final MarshallingInfo<String> USERID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UserId").build();
    private static final MarshallingInfo<String> ERRORCODE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ErrorCode").build();
    private static final MarshallingInfo<String> ERRORMESSAGE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ErrorMessage").build();
    private static final UserErrorMarshaller instance = new UserErrorMarshaller();

    public static UserErrorMarshaller getInstance() {
        return instance;
    }

    public void marshall(UserError userError, ProtocolMarshaller protocolMarshaller) {
        if (userError == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(userError.getUserId(), USERID_BINDING);
            protocolMarshaller.marshall(userError.getErrorCode(), ERRORCODE_BINDING);
            protocolMarshaller.marshall(userError.getErrorMessage(), ERRORMESSAGE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

