/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chime.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.chime.model.PhoneNumberOrder;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class PhoneNumberOrderMarshaller {
    private static final MarshallingInfo<String> PHONENUMBERORDERID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PhoneNumberOrderId").build();
    private static final MarshallingInfo<String> PRODUCTTYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProductType").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").build();
    private static final MarshallingInfo<List> ORDEREDPHONENUMBERS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OrderedPhoneNumbers").build();
    private static final MarshallingInfo<Date> CREATEDTIMESTAMP_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedTimestamp").timestampFormat("iso8601").build();
    private static final MarshallingInfo<Date> UPDATEDTIMESTAMP_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UpdatedTimestamp").timestampFormat("iso8601").build();
    private static final PhoneNumberOrderMarshaller instance = new PhoneNumberOrderMarshaller();

    public static PhoneNumberOrderMarshaller getInstance() {
        return instance;
    }

    public void marshall(PhoneNumberOrder phoneNumberOrder, ProtocolMarshaller protocolMarshaller) {
        if (phoneNumberOrder == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(phoneNumberOrder.getPhoneNumberOrderId(), PHONENUMBERORDERID_BINDING);
            protocolMarshaller.marshall(phoneNumberOrder.getProductType(), PRODUCTTYPE_BINDING);
            protocolMarshaller.marshall(phoneNumberOrder.getStatus(), STATUS_BINDING);
            protocolMarshaller.marshall(phoneNumberOrder.getOrderedPhoneNumbers(), ORDEREDPHONENUMBERS_BINDING);
            protocolMarshaller.marshall(phoneNumberOrder.getCreatedTimestamp(), CREATEDTIMESTAMP_BINDING);
            protocolMarshaller.marshall(phoneNumberOrder.getUpdatedTimestamp(), UPDATEDTIMESTAMP_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

