/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chime.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.chime.model.PhoneNumber;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class PhoneNumberMarshaller {
    private static final MarshallingInfo<String> PHONENUMBERID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PhoneNumberId").build();
    private static final MarshallingInfo<String> E164PHONENUMBER_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("E164PhoneNumber").build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Type").build();
    private static final MarshallingInfo<String> PRODUCTTYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProductType").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").build();
    private static final MarshallingInfo<StructuredPojo> CAPABILITIES_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Capabilities").build();
    private static final MarshallingInfo<List> ASSOCIATIONS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Associations").build();
    private static final MarshallingInfo<Date> CREATEDTIMESTAMP_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedTimestamp").timestampFormat("iso8601").build();
    private static final MarshallingInfo<Date> UPDATEDTIMESTAMP_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UpdatedTimestamp").timestampFormat("iso8601").build();
    private static final MarshallingInfo<Date> DELETIONTIMESTAMP_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeletionTimestamp").timestampFormat("iso8601").build();
    private static final PhoneNumberMarshaller instance = new PhoneNumberMarshaller();

    public static PhoneNumberMarshaller getInstance() {
        return instance;
    }

    public void marshall(PhoneNumber phoneNumber, ProtocolMarshaller protocolMarshaller) {
        if (phoneNumber == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(phoneNumber.getPhoneNumberId(), PHONENUMBERID_BINDING);
            protocolMarshaller.marshall(phoneNumber.getE164PhoneNumber(), E164PHONENUMBER_BINDING);
            protocolMarshaller.marshall(phoneNumber.getType(), TYPE_BINDING);
            protocolMarshaller.marshall(phoneNumber.getProductType(), PRODUCTTYPE_BINDING);
            protocolMarshaller.marshall(phoneNumber.getStatus(), STATUS_BINDING);
            protocolMarshaller.marshall(phoneNumber.getCapabilities(), CAPABILITIES_BINDING);
            protocolMarshaller.marshall(phoneNumber.getAssociations(), ASSOCIATIONS_BINDING);
            protocolMarshaller.marshall(phoneNumber.getCreatedTimestamp(), CREATEDTIMESTAMP_BINDING);
            protocolMarshaller.marshall(phoneNumber.getUpdatedTimestamp(), UPDATEDTIMESTAMP_BINDING);
            protocolMarshaller.marshall(phoneNumber.getDeletionTimestamp(), DELETIONTIMESTAMP_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

