/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chime.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.chime.model.PhoneNumberCapabilities;

@SdkInternalApi
public class PhoneNumberCapabilitiesMarshaller {
    private static final MarshallingInfo<Boolean> INBOUNDCALL_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InboundCall").build();
    private static final MarshallingInfo<Boolean> OUTBOUNDCALL_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OutboundCall").build();
    private static final MarshallingInfo<Boolean> INBOUNDSMS_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InboundSMS").build();
    private static final MarshallingInfo<Boolean> OUTBOUNDSMS_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OutboundSMS").build();
    private static final MarshallingInfo<Boolean> INBOUNDMMS_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InboundMMS").build();
    private static final MarshallingInfo<Boolean> OUTBOUNDMMS_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OutboundMMS").build();
    private static final PhoneNumberCapabilitiesMarshaller instance = new PhoneNumberCapabilitiesMarshaller();

    public static PhoneNumberCapabilitiesMarshaller getInstance() {
        return instance;
    }

    public void marshall(PhoneNumberCapabilities phoneNumberCapabilities, ProtocolMarshaller protocolMarshaller) {
        if (phoneNumberCapabilities == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(phoneNumberCapabilities.getInboundCall(), INBOUNDCALL_BINDING);
            protocolMarshaller.marshall(phoneNumberCapabilities.getOutboundCall(), OUTBOUNDCALL_BINDING);
            protocolMarshaller.marshall(phoneNumberCapabilities.getInboundSMS(), INBOUNDSMS_BINDING);
            protocolMarshaller.marshall(phoneNumberCapabilities.getOutboundSMS(), OUTBOUNDSMS_BINDING);
            protocolMarshaller.marshall(phoneNumberCapabilities.getInboundMMS(), INBOUNDMMS_BINDING);
            protocolMarshaller.marshall(phoneNumberCapabilities.getOutboundMMS(), OUTBOUNDMMS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

