/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chime.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.chime.model.Bot;
import java.util.Date;

@SdkInternalApi
public class BotMarshaller {
    private static final MarshallingInfo<String> BOTID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BotId").build();
    private static final MarshallingInfo<String> USERID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UserId").build();
    private static final MarshallingInfo<String> DISPLAYNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DisplayName").build();
    private static final MarshallingInfo<String> BOTTYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BotType").build();
    private static final MarshallingInfo<Boolean> DISABLED_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Disabled").build();
    private static final MarshallingInfo<Date> CREATEDTIMESTAMP_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedTimestamp").timestampFormat("iso8601").build();
    private static final MarshallingInfo<Date> UPDATEDTIMESTAMP_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UpdatedTimestamp").timestampFormat("iso8601").build();
    private static final MarshallingInfo<String> BOTEMAIL_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BotEmail").build();
    private static final MarshallingInfo<String> SECURITYTOKEN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SecurityToken").build();
    private static final BotMarshaller instance = new BotMarshaller();

    public static BotMarshaller getInstance() {
        return instance;
    }

    public void marshall(Bot bot, ProtocolMarshaller protocolMarshaller) {
        if (bot == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(bot.getBotId(), BOTID_BINDING);
            protocolMarshaller.marshall(bot.getUserId(), USERID_BINDING);
            protocolMarshaller.marshall(bot.getDisplayName(), DISPLAYNAME_BINDING);
            protocolMarshaller.marshall(bot.getBotType(), BOTTYPE_BINDING);
            protocolMarshaller.marshall(bot.getDisabled(), DISABLED_BINDING);
            protocolMarshaller.marshall(bot.getCreatedTimestamp(), CREATEDTIMESTAMP_BINDING);
            protocolMarshaller.marshall(bot.getUpdatedTimestamp(), UPDATEDTIMESTAMP_BINDING);
            protocolMarshaller.marshall(bot.getBotEmail(), BOTEMAIL_BINDING);
            protocolMarshaller.marshall(bot.getSecurityToken(), SECURITYTOKEN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

