/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.backup.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.backup.model.BackupSelectionsListMember;
import java.util.Date;

@SdkInternalApi
public class BackupSelectionsListMemberMarshaller {
    private static final MarshallingInfo<String> SELECTIONID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SelectionId").build();
    private static final MarshallingInfo<String> SELECTIONNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SelectionName").build();
    private static final MarshallingInfo<String> BACKUPPLANID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BackupPlanId").build();
    private static final MarshallingInfo<Date> CREATIONDATE_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationDate").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> CREATORREQUESTID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatorRequestId").build();
    private static final MarshallingInfo<String> IAMROLEARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IamRoleArn").build();
    private static final BackupSelectionsListMemberMarshaller instance = new BackupSelectionsListMemberMarshaller();

    public static BackupSelectionsListMemberMarshaller getInstance() {
        return instance;
    }

    public void marshall(BackupSelectionsListMember backupSelectionsListMember, ProtocolMarshaller protocolMarshaller) {
        if (backupSelectionsListMember == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(backupSelectionsListMember.getSelectionId(), SELECTIONID_BINDING);
            protocolMarshaller.marshall(backupSelectionsListMember.getSelectionName(), SELECTIONNAME_BINDING);
            protocolMarshaller.marshall(backupSelectionsListMember.getBackupPlanId(), BACKUPPLANID_BINDING);
            protocolMarshaller.marshall(backupSelectionsListMember.getCreationDate(), CREATIONDATE_BINDING);
            protocolMarshaller.marshall(backupSelectionsListMember.getCreatorRequestId(), CREATORREQUESTID_BINDING);
            protocolMarshaller.marshall(backupSelectionsListMember.getIamRoleArn(), IAMROLEARN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

