/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.backup.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.backup.model.BackupRule;
import com.amazonaws.services.backup.model.transform.BackupPlanMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BackupPlan
implements Serializable,
Cloneable,
StructuredPojo {
    private String backupPlanName;
    private List<BackupRule> rules;

    public void setBackupPlanName(String backupPlanName) {
        this.backupPlanName = backupPlanName;
    }

    public String getBackupPlanName() {
        return this.backupPlanName;
    }

    public BackupPlan withBackupPlanName(String backupPlanName) {
        this.setBackupPlanName(backupPlanName);
        return this;
    }

    public List<BackupRule> getRules() {
        return this.rules;
    }

    public void setRules(Collection<BackupRule> rules) {
        if (rules == null) {
            this.rules = null;
            return;
        }
        this.rules = new ArrayList<BackupRule>(rules);
    }

    public BackupPlan withRules(BackupRule ... rules) {
        if (this.rules == null) {
            this.setRules(new ArrayList<BackupRule>(rules.length));
        }
        for (BackupRule ele : rules) {
            this.rules.add(ele);
        }
        return this;
    }

    public BackupPlan withRules(Collection<BackupRule> rules) {
        this.setRules(rules);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBackupPlanName() != null) {
            sb.append("BackupPlanName: ").append(this.getBackupPlanName()).append(",");
        }
        if (this.getRules() != null) {
            sb.append("Rules: ").append(this.getRules());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BackupPlan)) {
            return false;
        }
        BackupPlan other = (BackupPlan)obj;
        if (other.getBackupPlanName() == null ^ this.getBackupPlanName() == null) {
            return false;
        }
        if (other.getBackupPlanName() != null && !other.getBackupPlanName().equals(this.getBackupPlanName())) {
            return false;
        }
        if (other.getRules() == null ^ this.getRules() == null) {
            return false;
        }
        return other.getRules() == null || other.getRules().equals(this.getRules());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBackupPlanName() == null ? 0 : this.getBackupPlanName().hashCode());
        hashCode = 31 * hashCode + (this.getRules() == null ? 0 : this.getRules().hashCode());
        return hashCode;
    }

    public BackupPlan clone() {
        try {
            return (BackupPlan)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BackupPlanMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

