/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscalingplans.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.autoscalingplans.model.Datapoint;
import java.util.Date;

@SdkInternalApi
public class DatapointMarshaller {
    private static final MarshallingInfo<Date> TIMESTAMP_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Timestamp").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Double> VALUE_BINDING = MarshallingInfo.builder(MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Value").build();
    private static final DatapointMarshaller instance = new DatapointMarshaller();

    public static DatapointMarshaller getInstance() {
        return instance;
    }

    public void marshall(Datapoint datapoint, ProtocolMarshaller protocolMarshaller) {
        if (datapoint == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(datapoint.getTimestamp(), TIMESTAMP_BINDING);
            protocolMarshaller.marshall(datapoint.getValue(), VALUE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

