/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appmesh.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.appmesh.model.VirtualNodeData;

@SdkInternalApi
public class VirtualNodeDataMarshaller {
    private static final MarshallingInfo<String> MESHNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("meshName").build();
    private static final MarshallingInfo<StructuredPojo> METADATA_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("metadata").build();
    private static final MarshallingInfo<StructuredPojo> SPEC_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("spec").build();
    private static final MarshallingInfo<StructuredPojo> STATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").build();
    private static final MarshallingInfo<String> VIRTUALNODENAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("virtualNodeName").build();
    private static final VirtualNodeDataMarshaller instance = new VirtualNodeDataMarshaller();

    public static VirtualNodeDataMarshaller getInstance() {
        return instance;
    }

    public void marshall(VirtualNodeData virtualNodeData, ProtocolMarshaller protocolMarshaller) {
        if (virtualNodeData == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(virtualNodeData.getMeshName(), MESHNAME_BINDING);
            protocolMarshaller.marshall(virtualNodeData.getMetadata(), METADATA_BINDING);
            protocolMarshaller.marshall(virtualNodeData.getSpec(), SPEC_BINDING);
            protocolMarshaller.marshall(virtualNodeData.getStatus(), STATUS_BINDING);
            protocolMarshaller.marshall(virtualNodeData.getVirtualNodeName(), VIRTUALNODENAME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

