/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appmesh.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.appmesh.model.TagRef;
import com.amazonaws.services.appmesh.model.VirtualRouterSpec;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateVirtualRouterRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String clientToken;
    private String meshName;
    private VirtualRouterSpec spec;
    private List<TagRef> tags;
    private String virtualRouterName;

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public CreateVirtualRouterRequest withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    public void setMeshName(String meshName) {
        this.meshName = meshName;
    }

    public String getMeshName() {
        return this.meshName;
    }

    public CreateVirtualRouterRequest withMeshName(String meshName) {
        this.setMeshName(meshName);
        return this;
    }

    public void setSpec(VirtualRouterSpec spec) {
        this.spec = spec;
    }

    public VirtualRouterSpec getSpec() {
        return this.spec;
    }

    public CreateVirtualRouterRequest withSpec(VirtualRouterSpec spec) {
        this.setSpec(spec);
        return this;
    }

    public List<TagRef> getTags() {
        return this.tags;
    }

    public void setTags(Collection<TagRef> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<TagRef>(tags);
    }

    public CreateVirtualRouterRequest withTags(TagRef ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<TagRef>(tags.length));
        }
        for (TagRef ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateVirtualRouterRequest withTags(Collection<TagRef> tags) {
        this.setTags(tags);
        return this;
    }

    public void setVirtualRouterName(String virtualRouterName) {
        this.virtualRouterName = virtualRouterName;
    }

    public String getVirtualRouterName() {
        return this.virtualRouterName;
    }

    public CreateVirtualRouterRequest withVirtualRouterName(String virtualRouterName) {
        this.setVirtualRouterName(virtualRouterName);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getClientToken() != null) {
            sb.append("ClientToken: ").append(this.getClientToken()).append(",");
        }
        if (this.getMeshName() != null) {
            sb.append("MeshName: ").append(this.getMeshName()).append(",");
        }
        if (this.getSpec() != null) {
            sb.append("Spec: ").append(this.getSpec()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getVirtualRouterName() != null) {
            sb.append("VirtualRouterName: ").append(this.getVirtualRouterName());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVirtualRouterRequest)) {
            return false;
        }
        CreateVirtualRouterRequest other = (CreateVirtualRouterRequest)obj;
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        if (other.getClientToken() != null && !other.getClientToken().equals(this.getClientToken())) {
            return false;
        }
        if (other.getMeshName() == null ^ this.getMeshName() == null) {
            return false;
        }
        if (other.getMeshName() != null && !other.getMeshName().equals(this.getMeshName())) {
            return false;
        }
        if (other.getSpec() == null ^ this.getSpec() == null) {
            return false;
        }
        if (other.getSpec() != null && !other.getSpec().equals(this.getSpec())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getVirtualRouterName() == null ^ this.getVirtualRouterName() == null) {
            return false;
        }
        return other.getVirtualRouterName() == null || other.getVirtualRouterName().equals(this.getVirtualRouterName());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        hashCode = 31 * hashCode + (this.getMeshName() == null ? 0 : this.getMeshName().hashCode());
        hashCode = 31 * hashCode + (this.getSpec() == null ? 0 : this.getSpec().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getVirtualRouterName() == null ? 0 : this.getVirtualRouterName().hashCode());
        return hashCode;
    }

    @Override
    public CreateVirtualRouterRequest clone() {
        return (CreateVirtualRouterRequest)super.clone();
    }
}

