/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.applicationinsights.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.applicationinsights.model.SeverityLevel;
import com.amazonaws.services.applicationinsights.model.Status;
import com.amazonaws.services.applicationinsights.model.transform.ProblemMarshaller;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class Problem
implements Serializable,
Cloneable,
StructuredPojo {
    private String id;
    private String title;
    private String insights;
    private String status;
    private String affectedResource;
    private Date startTime;
    private Date endTime;
    private String severityLevel;
    private String resourceGroupName;
    private Map<String, String> feedback;

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public Problem withId(String id) {
        this.setId(id);
        return this;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public Problem withTitle(String title) {
        this.setTitle(title);
        return this;
    }

    public void setInsights(String insights) {
        this.insights = insights;
    }

    public String getInsights() {
        return this.insights;
    }

    public Problem withInsights(String insights) {
        this.setInsights(insights);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public Problem withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public Problem withStatus(Status status) {
        this.status = status.toString();
        return this;
    }

    public void setAffectedResource(String affectedResource) {
        this.affectedResource = affectedResource;
    }

    public String getAffectedResource() {
        return this.affectedResource;
    }

    public Problem withAffectedResource(String affectedResource) {
        this.setAffectedResource(affectedResource);
        return this;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Problem withStartTime(Date startTime) {
        this.setStartTime(startTime);
        return this;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public Problem withEndTime(Date endTime) {
        this.setEndTime(endTime);
        return this;
    }

    public void setSeverityLevel(String severityLevel) {
        this.severityLevel = severityLevel;
    }

    public String getSeverityLevel() {
        return this.severityLevel;
    }

    public Problem withSeverityLevel(String severityLevel) {
        this.setSeverityLevel(severityLevel);
        return this;
    }

    public Problem withSeverityLevel(SeverityLevel severityLevel) {
        this.severityLevel = severityLevel.toString();
        return this;
    }

    public void setResourceGroupName(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
    }

    public String getResourceGroupName() {
        return this.resourceGroupName;
    }

    public Problem withResourceGroupName(String resourceGroupName) {
        this.setResourceGroupName(resourceGroupName);
        return this;
    }

    public Map<String, String> getFeedback() {
        return this.feedback;
    }

    public void setFeedback(Map<String, String> feedback) {
        this.feedback = feedback;
    }

    public Problem withFeedback(Map<String, String> feedback) {
        this.setFeedback(feedback);
        return this;
    }

    public Problem addFeedbackEntry(String key, String value) {
        if (null == this.feedback) {
            this.feedback = new HashMap<String, String>();
        }
        if (this.feedback.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.feedback.put(key, value);
        return this;
    }

    public Problem clearFeedbackEntries() {
        this.feedback = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getId() != null) {
            sb.append("Id: ").append(this.getId()).append(",");
        }
        if (this.getTitle() != null) {
            sb.append("Title: ").append(this.getTitle()).append(",");
        }
        if (this.getInsights() != null) {
            sb.append("Insights: ").append(this.getInsights()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getAffectedResource() != null) {
            sb.append("AffectedResource: ").append(this.getAffectedResource()).append(",");
        }
        if (this.getStartTime() != null) {
            sb.append("StartTime: ").append(this.getStartTime()).append(",");
        }
        if (this.getEndTime() != null) {
            sb.append("EndTime: ").append(this.getEndTime()).append(",");
        }
        if (this.getSeverityLevel() != null) {
            sb.append("SeverityLevel: ").append(this.getSeverityLevel()).append(",");
        }
        if (this.getResourceGroupName() != null) {
            sb.append("ResourceGroupName: ").append(this.getResourceGroupName()).append(",");
        }
        if (this.getFeedback() != null) {
            sb.append("Feedback: ").append(this.getFeedback());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Problem)) {
            return false;
        }
        Problem other = (Problem)obj;
        if (other.getId() == null ^ this.getId() == null) {
            return false;
        }
        if (other.getId() != null && !other.getId().equals(this.getId())) {
            return false;
        }
        if (other.getTitle() == null ^ this.getTitle() == null) {
            return false;
        }
        if (other.getTitle() != null && !other.getTitle().equals(this.getTitle())) {
            return false;
        }
        if (other.getInsights() == null ^ this.getInsights() == null) {
            return false;
        }
        if (other.getInsights() != null && !other.getInsights().equals(this.getInsights())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getAffectedResource() == null ^ this.getAffectedResource() == null) {
            return false;
        }
        if (other.getAffectedResource() != null && !other.getAffectedResource().equals(this.getAffectedResource())) {
            return false;
        }
        if (other.getStartTime() == null ^ this.getStartTime() == null) {
            return false;
        }
        if (other.getStartTime() != null && !other.getStartTime().equals(this.getStartTime())) {
            return false;
        }
        if (other.getEndTime() == null ^ this.getEndTime() == null) {
            return false;
        }
        if (other.getEndTime() != null && !other.getEndTime().equals(this.getEndTime())) {
            return false;
        }
        if (other.getSeverityLevel() == null ^ this.getSeverityLevel() == null) {
            return false;
        }
        if (other.getSeverityLevel() != null && !other.getSeverityLevel().equals(this.getSeverityLevel())) {
            return false;
        }
        if (other.getResourceGroupName() == null ^ this.getResourceGroupName() == null) {
            return false;
        }
        if (other.getResourceGroupName() != null && !other.getResourceGroupName().equals(this.getResourceGroupName())) {
            return false;
        }
        if (other.getFeedback() == null ^ this.getFeedback() == null) {
            return false;
        }
        return other.getFeedback() == null || other.getFeedback().equals(this.getFeedback());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getId() == null ? 0 : this.getId().hashCode());
        hashCode = 31 * hashCode + (this.getTitle() == null ? 0 : this.getTitle().hashCode());
        hashCode = 31 * hashCode + (this.getInsights() == null ? 0 : this.getInsights().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getAffectedResource() == null ? 0 : this.getAffectedResource().hashCode());
        hashCode = 31 * hashCode + (this.getStartTime() == null ? 0 : this.getStartTime().hashCode());
        hashCode = 31 * hashCode + (this.getEndTime() == null ? 0 : this.getEndTime().hashCode());
        hashCode = 31 * hashCode + (this.getSeverityLevel() == null ? 0 : this.getSeverityLevel().hashCode());
        hashCode = 31 * hashCode + (this.getResourceGroupName() == null ? 0 : this.getResourceGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getFeedback() == null ? 0 : this.getFeedback().hashCode());
        return hashCode;
    }

    public Problem clone() {
        try {
            return (Problem)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ProblemMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

